/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.makeithappen.model.task.util;

import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.ecp.makeithappen.model.task.Gender;
import org.eclipse.emf.ecp.makeithappen.model.task.Nationality;
import org.eclipse.emf.ecp.makeithappen.model.task.Task;
import org.eclipse.emf.ecp.makeithappen.model.task.TaskPackage;
import org.eclipse.emf.ecp.makeithappen.model.task.User;
import org.eclipse.emf.ecp.makeithappen.model.task.UserGroup;

public class TaskValidator
extends EObjectValidator {
    public static final TaskValidator INSTANCE = new TaskValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecp.makeithappen.model.task";
    public static final int TASK__HAS_NAME = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return TaskPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateTask((Task)value, diagnostics, context);
            }
            case 1: {
                return this.validateUser((User)value, diagnostics, context);
            }
            case 2: {
                return this.validateUserGroup((UserGroup)value, diagnostics, context);
            }
            case 3: {
                return this.validateGender((Gender)((Object)value), diagnostics, context);
            }
            case 4: {
                return this.validateNationality((Nationality)((Object)value), diagnostics, context);
            }
            case 5: {
                return this.validateDateOfBirth((XMLGregorianCalendar)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateTask(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(task, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(task, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(task, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTask_hasName(task, diagnostics, context);
        }
        return result;
    }

    public boolean validateTask_hasName(Task task, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return task.hasName(diagnostics, context);
    }

    public boolean validateUser(User user, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(user, diagnostics, context);
    }

    public boolean validateUserGroup(UserGroup userGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(userGroup, diagnostics, context);
    }

    public boolean validateGender(Gender gender, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateNationality(Nationality nationality, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDateOfBirth(XMLGregorianCalendar dateOfBirth, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

