/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.json.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.emf2web.json.generator.JsonGenerator;
import org.eclipse.emf.ecp.emf2web.util.TypeMapper;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EcoreJsonGenerator
extends JsonGenerator {
    private static final String TYPE = "type";
    private static final String OBJECT = "object";
    private static final String REQUIRED = "required";
    private static final String PROPERTIES = "properties";
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    private final HashSet<EClass> visitedClasses = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonElement createJsonElement(EObject object) {
        JsonElement _xsynchronizedexpression = null;
        HashSet<EClass> hashSet = this.visitedClasses;
        synchronized (hashSet) {
            JsonElement _xblockexpression = null;
            this.visitedClasses.clear();
            _xsynchronizedexpression = _xblockexpression = this.createJsonSchemaElement(object);
        }
        return _xsynchronizedexpression;
    }

    private JsonElement _createJsonSchemaElement(EClass eClass) {
        JsonObject _xblockexpression = null;
        this.visitedClasses.add(eClass);
        JsonObject _jsonObject = new JsonObject();
        JsonObject jsonObject = this.withObjectType(_jsonObject);
        EList _eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        this.withProperties(jsonObject, (Collection<? extends EStructuralFeature>)_eAllStructuralFeatures);
        this.with(jsonObject, ADDITIONAL_PROPERTIES, false);
        EList _eAllStructuralFeatures_1 = eClass.getEAllStructuralFeatures();
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature it) {
                return it.isRequired();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eAllStructuralFeatures_1, (Functions.Function1)_function);
        _xblockexpression = this.withRequiredProperties(jsonObject, _filter);
        return _xblockexpression;
    }

    private JsonElement _createJsonSchemaElement(EAttribute attribute) {
        JsonObject _jsonObject = new JsonObject();
        EClassifier _eType = attribute.getEType();
        int _upperBound = attribute.getUpperBound();
        return this.withTypeProperties(_jsonObject, _eType, _upperBound);
    }

    private JsonObject withTypeProperties(JsonObject jsonObject, EClassifier eClassifier, int upper) {
        JsonObject _xblockexpression = null;
        if (upper > 1 || upper == -1) {
            this.withType(jsonObject, "array");
            JsonObject _jsonObject = new JsonObject();
            JsonObject _withTypeProperties = this.withTypeProperties(_jsonObject, eClassifier);
            this.with(jsonObject, "items", _withTypeProperties);
        } else {
            this.withTypeProperties(jsonObject, eClassifier);
        }
        _xblockexpression = jsonObject;
        return _xblockexpression;
    }

    private JsonObject withTypeProperties(JsonObject jsonObject, EClassifier eClassifier) {
        JsonObject _xblockexpression = null;
        String _jsonType = this.jsonType(eClassifier);
        this.withType(jsonObject, _jsonType);
        boolean _isDateType = TypeMapper.isDateType((EClassifier)eClassifier);
        if (_isDateType) {
            this.with(jsonObject, "format", "date-time");
        } else {
            boolean _isEnumType = TypeMapper.isEnumType((EClassifier)eClassifier);
            if (_isEnumType) {
                EEnum eEnum = (EEnum)eClassifier;
                JsonArray literalArray = new JsonArray();
                EList _eLiterals = eEnum.getELiterals();
                Functions.Function1<EEnumLiteral, String> _function = new Functions.Function1<EEnumLiteral, String>(){

                    public String apply(EEnumLiteral it) {
                        return it.getName();
                    }
                };
                List _map = ListExtensions.map((List)_eLiterals, (Functions.Function1)_function);
                for (String name : _map) {
                    JsonPrimitive _jsonPrimitive = new JsonPrimitive(name);
                    literalArray.add((JsonElement)_jsonPrimitive);
                }
                this.with(jsonObject, "enum", literalArray);
            }
        }
        _xblockexpression = jsonObject;
        return _xblockexpression;
    }

    private String jsonType(EClassifier eClassifier) {
        boolean _isNumberType;
        boolean _isIntegerType;
        boolean _isBooleanType;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && (_isBooleanType = TypeMapper.isBooleanType((EClassifier)eClassifier))) {
            _matched = true;
            _switchResult = "boolean";
        }
        if (!_matched && (_isIntegerType = TypeMapper.isIntegerType((EClassifier)eClassifier))) {
            _matched = true;
            _switchResult = "integer";
        }
        if (!_matched && (_isNumberType = TypeMapper.isNumberType((EClassifier)eClassifier))) {
            _matched = true;
            _switchResult = "number";
        }
        if (!_matched) {
            _switchResult = "string";
        }
        return _switchResult;
    }

    private JsonElement _createJsonSchemaElement(EReference reference) {
        int _upperBound_1;
        boolean _equals;
        boolean _greaterThan;
        JsonElement _xblockexpression = null;
        JsonObject jsonObject = new JsonObject();
        JsonElement _xifexpression = null;
        boolean _or = false;
        int _upperBound = reference.getUpperBound();
        boolean bl = _greaterThan = _upperBound > 1;
        _or = _greaterThan ? true : (_equals = (_upperBound_1 = reference.getUpperBound()) == -1);
        if (_or) {
            JsonObject _xblockexpression_1 = null;
            this.withType(jsonObject, "array");
            EClass _eReferenceType = reference.getEReferenceType();
            JsonElement _createJsonSchemaElement = this.createJsonSchemaElement((EObject)_eReferenceType);
            _xblockexpression_1 = this.with(jsonObject, "items", _createJsonSchemaElement);
            _xifexpression = _xblockexpression_1;
        } else {
            EClass _eReferenceType = reference.getEReferenceType();
            _xifexpression = this.createJsonSchemaElement((EObject)_eReferenceType);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JsonElement _createJsonSchemaElement(EObject eObject) {
        throw new UnsupportedOperationException("Cannot create a Json Schema element for EObjects that are not EClasses, EEnums, EAttributes, or EReferences.");
    }

    private JsonObject withObjectType(JsonObject object) {
        return this.withType(object, OBJECT);
    }

    private JsonObject withType(JsonObject jsonObject, String type) {
        return this.with(jsonObject, TYPE, type);
    }

    private JsonObject withRequiredProperties(JsonObject jsonObject, Iterable<EStructuralFeature> requiredProperties) {
        boolean _not;
        JsonObject _xblockexpression = null;
        JsonArray requiredPropertiesArray = new JsonArray();
        Functions.Function1<EStructuralFeature, String> _function = new Functions.Function1<EStructuralFeature, String>(){

            public String apply(EStructuralFeature it) {
                return it.getName();
            }
        };
        Iterable _map = IterableExtensions.map(requiredProperties, (Functions.Function1)_function);
        for (String name : _map) {
            JsonPrimitive _jsonPrimitive = new JsonPrimitive(name);
            requiredPropertiesArray.add((JsonElement)_jsonPrimitive);
        }
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)requiredPropertiesArray);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.with(jsonObject, REQUIRED, requiredPropertiesArray);
        }
        _xblockexpression = jsonObject;
        return _xblockexpression;
    }

    private JsonObject withProperties(JsonObject jsonObject, Collection<? extends EStructuralFeature> features) {
        JsonObject _xblockexpression = null;
        JsonObject propertyObject = new JsonObject();
        for (EStructuralFeature eStructuralFeature : features) {
            boolean _isNotCircle = this.isNotCircle(eStructuralFeature);
            if (!_isNotCircle) continue;
            JsonElement jsonElement = this.createJsonSchemaElement((EObject)eStructuralFeature);
            String _name = eStructuralFeature.getName();
            propertyObject.add(_name, jsonElement);
        }
        _xblockexpression = this.with(jsonObject, PROPERTIES, propertyObject);
        return _xblockexpression;
    }

    private boolean isNotCircle(EStructuralFeature feature) {
        boolean _xblockexpression = false;
        if (feature instanceof EReference) {
            EClassifier _eType = ((EReference)feature).getEType();
            boolean _contains = this.visitedClasses.contains(_eType);
            return !_contains;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    private JsonElement createJsonSchemaElement(EObject attribute) {
        if (attribute instanceof EAttribute) {
            return this._createJsonSchemaElement((EAttribute)attribute);
        }
        if (attribute instanceof EReference) {
            return this._createJsonSchemaElement((EReference)attribute);
        }
        if (attribute instanceof EClass) {
            return this._createJsonSchemaElement((EClass)attribute);
        }
        if (attribute != null) {
            return this._createJsonSchemaElement(attribute);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(attribute).toString());
    }
}

