/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.view.internal.service;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecp.ide.view.service.IDEViewModelRegistry;
import org.eclipse.emf.ecp.ide.view.service.ViewModelEditorCallback;
import org.eclipse.emf.ecp.view.spi.model.VView;

public class IDEViewModelRegistryImpl
implements IDEViewModelRegistry {
    private Map<VView, ViewModelEditorCallback> viewModelViewModelEditorMapping = new LinkedHashMap<VView, ViewModelEditorCallback>();
    private Map<String, Set<VView>> ecoreViewMapping = new LinkedHashMap<String, Set<VView>>();

    @Override
    public void register(String ecorePath, VView viewModel) {
        if (!this.ecoreViewMapping.containsKey(ecorePath)) {
            this.ecoreViewMapping.put(ecorePath, new LinkedHashSet());
            this.addECoreChangeListener(ecorePath);
        }
        this.ecoreViewMapping.get(ecorePath).add(viewModel);
    }

    private void addECoreChangeListener(final String ecorePath) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                while (delta.getAffectedChildren().length != 0) {
                    delta = delta.getAffectedChildren()[0];
                }
                if (ecorePath.contains(delta.getResource().getFullPath().toString())) {
                    for (VView view : (Set)IDEViewModelRegistryImpl.this.ecoreViewMapping.get(ecorePath)) {
                        ViewModelEditorCallback viewModelEditorCallback = (ViewModelEditorCallback)IDEViewModelRegistryImpl.this.viewModelViewModelEditorMapping.get(view);
                        if (viewModelEditorCallback == null) continue;
                        viewModelEditorCallback.reloadViewModel();
                    }
                }
            }
        });
    }

    @Override
    public void unregister(String registeredEcorePath, VView viewModel) {
        if (this.ecoreViewMapping.containsKey(registeredEcorePath)) {
            this.ecoreViewMapping.get(registeredEcorePath).remove(viewModel);
        }
    }

    @Override
    public void registerViewModelEditor(VView viewModel, ViewModelEditorCallback viewModelEditor) {
        this.viewModelViewModelEditorMapping.put(viewModel, viewModelEditor);
    }

    @Override
    public void unregisterViewModelEditor(VView viewModel, ViewModelEditorCallback viewModelEditor) {
        this.viewModelViewModelEditorMapping.remove(viewModel);
    }
}

