/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.view.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAttributesDialog
extends Dialog {
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryLabelProvider labelProvider;
    private final ECPProject project;
    private final Set<EStructuralFeature> selectedFeatures = new LinkedHashSet<EStructuralFeature>();
    private EClass dataSegment;
    private final EClass rootClass;

    public SelectAttributesDialog(ECPProject project, EClass rootClass, Shell parentShell) {
        super(parentShell);
        this.project = project;
        this.rootClass = rootClass;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Label labelDatasegment = new Label(composite, 0);
        labelDatasegment.setText("Select Datasegment");
        final ComboViewer cvDatasegment = new ComboViewer(composite, 8);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        cvDatasegment.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        cvDatasegment.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Button bUnreferenced = new Button(composite, 32);
        bUnreferenced.setText("Show only unreferenced Attributes?");
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)bUnreferenced);
        Label labelAttributes = new Label(composite, 0);
        labelAttributes.setText("Select Attributes");
        final CheckboxTableViewer tvAttributes = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        tvAttributes.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tvAttributes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(-1, 200).applyTo(tvAttributes.getControl());
        tvAttributes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EStructuralFeature object = (EStructuralFeature)event.getElement();
                if (event.getChecked()) {
                    SelectAttributesDialog.this.selectedFeatures.add(object);
                } else {
                    SelectAttributesDialog.this.selectedFeatures.remove(object);
                }
            }
        });
        cvDatasegment.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectAttributesDialog.this.dataSegment = (EClass)((IStructuredSelection)event.getSelection()).getFirstElement();
                Object attributes = null;
                attributes = !bUnreferenced.getSelection() ? SelectAttributesDialog.this.dataSegment.getEAllStructuralFeatures() : SelectAttributesDialog.this.getUnreferencedSegmentAttributes(SelectAttributesDialog.this.dataSegment);
                tvAttributes.setInput(attributes);
            }
        });
        bUnreferenced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EClass dataSegment = (EClass)((IStructuredSelection)cvDatasegment.getSelection()).getFirstElement();
                Object attributes = null;
                attributes = !bUnreferenced.getSelection() ? dataSegment.getEAllStructuralFeatures() : SelectAttributesDialog.this.getUnreferencedSegmentAttributes(dataSegment);
                tvAttributes.setInput(attributes);
            }
        });
        Composite compositeButtons = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(compositeButtons);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)compositeButtons);
        Button bSelectAll = new Button(compositeButtons, 8);
        bSelectAll.setText("Select All");
        bSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)tvAttributes.getInput();
                tvAttributes.setAllChecked(true);
                SelectAttributesDialog.this.selectedFeatures.addAll(segments);
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bSelectAll);
        Button bDeSelectAll = new Button(compositeButtons, 8);
        bDeSelectAll.setText("Deselect All");
        bDeSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)tvAttributes.getInput();
                tvAttributes.setAllChecked(false);
                SelectAttributesDialog.this.selectedFeatures.removeAll(segments);
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bDeSelectAll);
        Set<EClass> datasegments = Helper.getDatasegmentSubclasses(this.rootClass);
        cvDatasegment.setInput(datasegments);
        if (datasegments.size() > 0) {
            cvDatasegment.setSelection((ISelection)new StructuredSelection((Object)datasegments.iterator().next()));
        }
        return composite;
    }

    public boolean close() {
        this.labelProvider.dispose();
        this.composedAdapterFactory.dispose();
        return super.close();
    }

    private List<EStructuralFeature> getUnreferencedSegmentAttributes(EClass eClass) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        ArrayList<EStructuralFeature> allStructuralFeatures = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        for (Object rootElement : this.project.getContents()) {
            if (!VView.class.isInstance(rootElement)) continue;
            VView viewConfiguration = (VView)rootElement;
            TreeIterator eAllContents = viewConfiguration.eAllContents();
            while (eAllContents.hasNext()) {
                EObject eObject = (EObject)eAllContents.next();
                if (!VControl.class.isInstance(eObject)) continue;
                VControl control = (VControl)eObject;
                VDomainModelReference domainModelReference = control.getDomainModelReference();
                Iterator structuralFeatureIterator = domainModelReference.getEStructuralFeatureIterator();
                while (structuralFeatureIterator.hasNext()) {
                    EStructuralFeature feature = (EStructuralFeature)structuralFeatureIterator.next();
                    if (feature == null || !feature.getEContainingClass().equals(eClass)) continue;
                    result.add(feature);
                }
            }
        }
        allStructuralFeatures.removeAll(result);
        return allStructuralFeatures;
    }

    public Set<EStructuralFeature> getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public EClass getDataSegment() {
        return this.dataSegment;
    }
}

