/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecp.edit.internal.swt.util.DoubleColumnRow;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTRenderingHelper;
import org.eclipse.emf.ecp.edit.internal.swt.util.SingleColumnRow;
import org.eclipse.emf.ecp.edit.internal.swt.util.ThreeColumnRow;
import org.eclipse.emf.ecp.view.spi.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.LayoutHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSWTRenderer<R extends VElement> {
    protected static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";

    public List<RenderingResultRow<Control>> render(Composite parent, R vElement, final ViewModelContext viewContext) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        List<RenderingResultRow<Control>> result = this.renderModel(parent, vElement, viewContext);
        if (result == null) {
            return null;
        }
        final ViewModelContext.ModelChangeListener listener = new ViewModelContext.ModelChangeListener((VElement)vElement, result){
            private final /* synthetic */ VElement val$vElement;
            private final /* synthetic */ List val$result;
            {
                this.val$vElement = vElement;
                this.val$result = list;
            }

            public void notifyRemove(Notifier notifier) {
            }

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getNotifier() != this.val$vElement) {
                    return;
                }
                if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Visible()) {
                    AbstractSWTRenderer.applyVisible(this.val$vElement, this.val$result);
                }
                if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Enabled() && !this.val$vElement.isReadonly()) {
                    AbstractSWTRenderer.applyEnable(this.val$vElement, this.val$result);
                }
            }

            public void notifyAdd(Notifier notifier) {
            }
        };
        viewContext.registerViewChangeListener(listener);
        parent.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                viewContext.unregisterViewChangeListener(listener);
            }
        });
        AbstractSWTRenderer.applyVisible(vElement, result);
        AbstractSWTRenderer.applyReadOnly(vElement, result);
        if (!vElement.isReadonly()) {
            AbstractSWTRenderer.applyEnable(vElement, result);
        }
        return result;
    }

    private static void applyReadOnly(VElement vElement, List<RenderingResultRow<Control>> resultRows) {
        for (RenderingResultRow<Control> row : resultRows) {
            for (Control control : row.getControls()) {
                control.setEnabled(!vElement.isReadonly());
            }
        }
    }

    protected static void applyEnable(VElement vElement, List<RenderingResultRow<Control>> resultRows) {
        for (RenderingResultRow<Control> row : resultRows) {
            for (Control control : row.getControls()) {
                control.setEnabled(vElement.isEnabled());
            }
        }
    }

    protected static void applyVisible(VElement vElement, List<RenderingResultRow<Control>> resultRows) {
        for (RenderingResultRow<Control> row : resultRows) {
            for (Control control : row.getControls()) {
                GridData gridData;
                Object layoutData = control.getLayoutData();
                if (GridData.class.isInstance(layoutData) && (gridData = (GridData)layoutData) != null) {
                    gridData.exclude = false;
                }
                control.setVisible(vElement.isVisible());
            }
        }
    }

    protected abstract List<RenderingResultRow<Control>> renderModel(Composite var1, R var2, ViewModelContext var3) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption;

    protected void setLayoutDataForResultRows(List<RenderingResultRow<Control>> resultRows) {
        for (RenderingResultRow<Control> row : resultRows) {
            if (SingleColumnRow.class.isInstance(row)) {
                ((SingleColumnRow)row).getControl().setLayoutData(this.getLayoutHelper().getSpanningLayoutData(3, 1));
                continue;
            }
            if (DoubleColumnRow.class.isInstance(row)) {
                ((DoubleColumnRow)row).getLeftControl().setLayoutData(this.getLayoutHelper().getLeftColumnLayoutData());
                ((DoubleColumnRow)row).getRightControl().setLayoutData(this.getLayoutHelper().getRightColumnLayoutData(2));
                continue;
            }
            if (!ThreeColumnRow.class.isInstance(row)) continue;
            ((ThreeColumnRow)row).getLeftControl().setLayoutData(this.getLayoutHelper().getLeftColumnLayoutData());
            ((ThreeColumnRow)row).getMiddleControl().setLayoutData(this.getLayoutHelper().getValidationColumnLayoutData());
            ((ThreeColumnRow)row).getRightControl().setLayoutData(this.getLayoutHelper().getRightColumnLayoutData(1));
        }
    }

    protected List<RenderingResultRow<Control>> createResult(Control ... controls) {
        return Collections.singletonList(SWTRenderingHelper.INSTANCE.getResultRowFactory().createRenderingResultRow((Object[])controls));
    }

    protected LayoutHelper<Layout> getLayoutHelper() {
        return SWTRenderingHelper.INSTANCE.getLayoutHelper();
    }
}

