/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.renderer;

import java.lang.reflect.ParameterizedType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.internal.ui.Activator;
import org.eclipse.emf.ecp.view.spi.renderer.LayoutHelper;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRowFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RenderingConfiguration {
    private static final String RENDERING_LAYOUT_HELPER = "renderingLayoutHelper";
    private static final String RENDERING_RESULT_ROW_FACTORY = "renderingResultRowFactory";
    private static final String RENDERING_CONFIGURATION_EXTENSION_POINT = "org.eclipse.emf.ecp.ui.view.renderingConfiguration";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final RenderingConfiguration INSTANCE = new RenderingConfiguration();
    private final Map<Class<?>, RenderingResultRowFactory<?>> rowFactories = new LinkedHashMap();
    private final Map<Class<?>, LayoutHelper<?>> layoutHelpers = new LinkedHashMap();

    public static RenderingConfiguration getCurrent() {
        return INSTANCE;
    }

    private RenderingConfiguration() {
        this.readExtensionPoint();
    }

    private void readExtensionPoint() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor(RENDERING_CONFIGURATION_EXTENSION_POINT);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = e.getChildren();
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement e2 = iConfigurationElementArray2[n4];
                try {
                    Class clazz;
                    if (RENDERING_RESULT_ROW_FACTORY.equalsIgnoreCase(e2.getName())) {
                        RenderingResultRowFactory rrrf = (RenderingResultRowFactory)e2.createExecutableExtension(CLASS_ATTRIBUTE);
                        clazz = (Class)((ParameterizedType)rrrf.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
                        this.rowFactories.put(clazz, rrrf);
                    } else if (RENDERING_LAYOUT_HELPER.equalsIgnoreCase(e2.getName())) {
                        LayoutHelper layoutHelper = (LayoutHelper)e2.createExecutableExtension(CLASS_ATTRIBUTE);
                        clazz = (Class)((ParameterizedType)layoutHelper.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
                        this.layoutHelpers.put(clazz, layoutHelper);
                    }
                }
                catch (CoreException ex) {
                    Activator.log((Exception)((Object)ex));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public <CONTROL> RenderingResultRowFactory<CONTROL> getRenderingRowFactory(Class<CONTROL> controlClazz) {
        return this.rowFactories.get(controlClazz);
    }

    public <LAYOUT> LayoutHelper<LAYOUT> getLayoutHelper(Class<LAYOUT> layoutClazz) {
        return this.layoutHelpers.get(layoutClazz);
    }
}

