/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.generator;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewProvider
implements IViewProvider {
    public VView generate(EObject eObject) {
        VView view = VViewFactory.eINSTANCE.createView();
        for (EStructuralFeature feature : this.getValidFeatures(eObject)) {
            VControl control = VViewFactory.eINSTANCE.createControl();
            VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            modelReference.setDomainModelEFeature(feature);
            control.setDomainModelReference((VDomainModelReference)modelReference);
            control.setReadonly(!feature.isChangeable());
            view.getChildren().add((Object)control);
        }
        return view;
    }

    private boolean isInvalidFeature(EStructuralFeature feature) {
        return this.isContainerReference(feature) || this.isTransient(feature) || this.isVolatile(feature);
    }

    private boolean isContainerReference(EStructuralFeature feature) {
        EReference reference;
        return feature instanceof EReference && (reference = (EReference)feature).isContainer();
    }

    private boolean isTransient(EStructuralFeature feature) {
        return feature.isTransient();
    }

    private boolean isVolatile(EStructuralFeature feature) {
        return feature.isVolatile();
    }

    private Set<EStructuralFeature> getValidFeatures(EObject eObject) {
        EList features = eObject.eClass().getEAllStructuralFeatures();
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        LinkedHashSet<EStructuralFeature> featuresToAdd = new LinkedHashSet<EStructuralFeature>();
        IItemPropertyDescriptor propertyDescriptor = null;
        for (EStructuralFeature feature : features) {
            propertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)eObject, (Object)feature);
            if (propertyDescriptor == null || this.isInvalidFeature(feature)) continue;
            featuresToAdd.add(feature);
        }
        composedAdapterFactory.dispose();
        return featuresToAdd;
    }

    public int canRender(EObject eObject) {
        return 1;
    }
}

