/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.validation.ViewModelGraphNode;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsNodeMapping {
    private static final EStructuralFeature ALL_FEATURES = null;
    private final Map<UniqueSetting, ViewModelGraphNode> settings = new LinkedHashMap<UniqueSetting, ViewModelGraphNode>();
    private final Comparator<VDiagnostic> comparator;

    public SettingsNodeMapping(Comparator<VDiagnostic> comparator) {
        this.comparator = comparator;
    }

    public ViewModelGraphNode getNode(EObject eObject, EStructuralFeature feature) {
        UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)feature);
        ViewModelGraphNode node = this.settings.get(setting);
        if (node == null) {
            return null;
        }
        return node;
    }

    public Set<ViewModelGraphNode> getAllNodes(EObject eObject) {
        LinkedHashSet<ViewModelGraphNode> result = new LinkedHashSet<ViewModelGraphNode>();
        EList eAllStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eAllStructuralFeatures) {
            UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)eStructuralFeature);
            ViewModelGraphNode viewModelGraphNode = this.settings.get(setting);
            if (viewModelGraphNode == null) continue;
            result.add(viewModelGraphNode);
        }
        return result;
    }

    public ViewModelGraphNode createNode(EObject eObject, EStructuralFeature feature, VDiagnostic value, boolean isDomainObject) {
        UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)feature);
        ViewModelGraphNode node = this.settings.get(setting);
        if (node == null) {
            node = this.createNode(setting, value, isDomainObject);
            this.settings.put(setting, node);
        } else {
            node.setValue(value);
        }
        return node;
    }

    private ViewModelGraphNode createNode(UniqueSetting setting, VDiagnostic initValue, boolean isDomainObject) {
        return new ViewModelGraphNode(setting, initValue, isDomainObject, this.comparator);
    }

    public void removeAll(EObject eObject) {
        EList eAllStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eAllStructuralFeatures) {
            UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)eStructuralFeature);
            this.settings.remove(setting);
        }
        UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)ALL_FEATURES);
        this.settings.remove(setting);
    }

    public static EStructuralFeature allFeatures() {
        return ALL_FEATURES;
    }
}

