/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.util.Disposable;
import org.eclipse.emf.ecp.internal.core.util.Element;
import org.eclipse.emf.ecp.internal.core.util.ElementRegistry;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;
import org.eclipse.emf.ecp.spi.core.util.InternalDescriptor;
import org.eclipse.emf.ecp.spi.core.util.InternalRegistryElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementDescriptor<ELEMENT extends ECPElement>
extends Element
implements InternalDescriptor<ELEMENT>,
ECPDisposable.DisposeListener {
    private final Disposable disposable = new Disposable(this){

        protected void doDispose() {
            if (ElementDescriptor.this.resolvedElement instanceof ECPDisposable) {
                try {
                    ((ECPDisposable)((Object)ElementDescriptor.this.resolvedElement)).dispose();
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
            ElementDescriptor.this.resolvedElement = null;
            ElementDescriptor.this.doDispose();
        }
    };
    private final ElementRegistry<ELEMENT, ?> registry;
    private String label;
    private String description;
    private ELEMENT resolvedElement;

    public ElementDescriptor(ElementRegistry<ELEMENT, ?> registry, String name) {
        super(name);
        this.registry = registry;
        this.label = name;
        this.description = "";
    }

    public final ElementRegistry<ELEMENT, ?> getRegistry() {
        return this.registry;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setLabel(String label) {
        this.label = label;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final void setDescription(String description) {
        this.description = description;
    }

    @Override
    public final boolean isResolved() {
        return this.resolvedElement != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ELEMENT getResolvedElement() {
        boolean resolved = false;
        ElementDescriptor elementDescriptor = this;
        synchronized (elementDescriptor) {
            if (this.resolvedElement == null) {
                try {
                    this.resolvedElement = this.resolve();
                    if (this.resolvedElement instanceof InternalRegistryElement) {
                        InternalRegistryElement registryElement = (InternalRegistryElement)this.resolvedElement;
                        registryElement.setLabel(this.getLabel());
                        registryElement.setDescription(this.getDescription());
                    }
                    if (this.resolvedElement instanceof ECPDisposable) {
                        ECPDisposable disposable = (ECPDisposable)this.resolvedElement;
                        disposable.addDisposeListener(this);
                    }
                    this.resolvedElement(this.resolvedElement);
                }
                catch (Throwable t) {
                    throw new Error("Unable to resolve " + this, t);
                }
                resolved = true;
            }
        }
        if (resolved) {
            this.registry.descriptorChanged(this, true);
        }
        return this.resolvedElement;
    }

    @Override
    public final boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    @Override
    public final void dispose() {
        this.disposable.dispose();
    }

    @Override
    public final void addDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.addDisposeListener(listener);
    }

    @Override
    public final void removeDisposeListener(ECPDisposable.DisposeListener listener) {
        this.disposable.removeDisposeListener(listener);
    }

    @Override
    public final void disposed(ECPDisposable disposable) {
        if (this.resolvedElement == disposable) {
            this.resolvedElement = null;
        }
        this.registry.descriptorChanged(this, false);
    }

    protected void doDispose() {
    }

    protected void resolvedElement(ELEMENT element) {
    }

    protected abstract ELEMENT resolve() throws Exception;
}

