/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi;

import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ViewLocaleService;
import org.eclipse.emf.ecp.internal.edit.Activator;
import org.eclipse.emf.ecp.view.spi.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECPAbstractControl {
    private boolean embedded;
    private EMFDataBindingContext dataBindingContext;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private ViewModelContext viewModelContext;
    private VControl control;
    private EStructuralFeature.Setting firstSetting;
    private EStructuralFeature firstFeature;
    private ViewModelContext.ModelChangeListener viewChangeListener;

    public final void init(ViewModelContext viewModelContext, final VControl control) {
        this.viewModelContext = viewModelContext;
        this.control = control;
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        this.viewChangeListener = new ViewModelContext.ModelChangeListener(){

            public void notifyRemove(Notifier notifier) {
            }

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getNotifier() != ECPAbstractControl.this.control) {
                    return;
                }
                if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Diagnostic()) {
                    ECPAbstractControl.this.applyValidation(control.getDiagnostic());
                    ECPAbstractControl.this.backwardCompatibleHandleValidation();
                }
                if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Enabled()) {
                    ECPAbstractControl.this.enabledmentChanged(control.isEnabled());
                }
            }

            public void notifyAdd(Notifier notifier) {
            }
        };
        viewModelContext.registerViewChangeListener(this.viewChangeListener);
        this.postInit();
    }

    protected void postInit() {
    }

    protected void enabledmentChanged(boolean enabled) {
        this.setEditable(enabled);
    }

    protected void applyValidation(VDiagnostic diagnostic) {
    }

    public IItemPropertyDescriptor getItemPropertyDescriptor(EStructuralFeature.Setting setting) {
        return this.adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
    }

    protected final VControl getControl() {
        return this.control;
    }

    protected final ViewModelContext getViewModelContext() {
        return this.viewModelContext;
    }

    public final EStructuralFeature.Setting getFirstSetting() {
        if (this.firstSetting == null) {
            Iterator iterator = this.control.getDomainModelReference().getIterator();
            int count = 0;
            this.firstSetting = null;
            while (iterator.hasNext()) {
                ++count;
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iterator.next();
                if (this.firstSetting != null) continue;
                this.firstSetting = setting;
            }
            if (count == 0) {
                Activator.logException(new IllegalArgumentException(String.valueOf(this.control.getName()) + " : " + "The passed VDomainModelReference resolves to no setting."));
            }
        }
        return this.firstSetting;
    }

    public final EStructuralFeature getFirstStructuralFeature() {
        if (this.firstFeature == null) {
            Iterator iterator = this.control.getDomainModelReference().getEStructuralFeatureIterator();
            int count = 0;
            this.firstFeature = null;
            while (iterator.hasNext()) {
                ++count;
                if (this.firstFeature == null) {
                    this.firstFeature = (EStructuralFeature)iterator.next();
                    continue;
                }
                iterator.next();
            }
            if (count == 0) {
                throw new IllegalArgumentException("The passed VDomainModelReference resolves to no EStructuralFeature.");
            }
        }
        return this.firstFeature;
    }

    public final DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    public void dispose() {
        this.composedAdapterFactory.dispose();
        this.composedAdapterFactory = null;
        this.adapterFactoryItemDelegator = null;
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
        }
        this.dataBindingContext = null;
        this.viewModelContext.unregisterViewChangeListener(this.viewChangeListener);
        this.viewModelContext = null;
        this.viewChangeListener = null;
        this.control = null;
        this.firstFeature = null;
        this.firstSetting = null;
    }

    protected final boolean isEmbedded() {
        return this.embedded;
    }

    public final void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    protected final EditingDomain getEditingDomain(EStructuralFeature.Setting setting) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)setting.getEObject());
    }

    protected final <T> T getService(Class<T> serviceClass) {
        return (T)this.viewModelContext.getService(serviceClass);
    }

    protected final Locale getLocale() {
        ViewLocaleService service = (ViewLocaleService)this.viewModelContext.getService(ViewLocaleService.class);
        if (service != null) {
            return service.getLocale();
        }
        return Locale.getDefault();
    }

    protected final VDomainModelReference getDomainModelReference() {
        return this.control.getDomainModelReference();
    }

    @Deprecated
    protected final EditingDomain getEditingDomain() {
        return this.getEditingDomain(this.getFirstSetting());
    }

    protected final void backwardCompatibleHandleValidation() {
        final VDiagnostic diagnostic = this.control.getDiagnostic();
        if (diagnostic == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ECPAbstractControl.this.control == null) {
                    return;
                }
                ECPAbstractControl.this.resetValidation();
                for (Object object : diagnostic.getDiagnostics()) {
                    ECPAbstractControl.this.handleValidation((Diagnostic)object);
                }
            }
        });
    }

    @Deprecated
    public void handleValidation(Diagnostic diagnostic) {
    }

    @Deprecated
    public void resetValidation() {
    }

    @Deprecated
    public boolean showLabel() {
        return true;
    }

    @Deprecated
    public void setEditable(boolean isEditable) {
    }
}

