/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.decorator;

import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.internal.ui.e3.Activator;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.observer.ESLoginObserver;
import org.eclipse.emf.emfstore.client.observer.ESLogoutObserver;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;

public class RepositoryViewLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
ESLoginObserver,
ESLogoutObserver {
    public void decorate(Object element, IDecoration decoration) {
        InternalRepository repository;
        InternalProvider provider;
        if (element instanceof ECPRepository && (provider = (repository = (InternalRepository)element).getProvider()) != null && "org.eclipse.emf.ecp.emfstore.provider".equalsIgnoreCase(provider.getName())) {
            ESServer server = EMFStoreProvider.INSTANCE.getServerInfo(repository);
            if (server.getLastUsersession() != null && server.getLastUsersession().isLoggedIn()) {
                decoration.addOverlay(Activator.getImageDescriptor("icons/bullet_green.png"), 3);
            } else {
                decoration.addOverlay(Activator.getImageDescriptor("icons/bullet_delete.png"), 3);
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void loginCompleted(ESUsersession session) {
        this.update(session);
    }

    public void logoutCompleted(ESUsersession session) {
        this.update(session);
    }

    private void update(final ESUsersession usersession) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                RepositoryViewLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)RepositoryViewLabelDecorator.this, (Object)((EMFStoreProvider)ECPUtil.getResolvedElement((ECPElement)ECPUtil.getECPProviderRegistry().getProvider("org.eclipse.emf.ecp.emfstore.provider"))).getRepository(usersession.getServer())));
            }
        });
    }
}

