/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.editor.view.control;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.ide.editor.view.control.Activator;
import org.eclipse.emf.ecp.view.editor.controls.ControlRootEClassControl;
import org.eclipse.emf.ecp.view.ideconfig.model.IDEConfig;
import org.eclipse.emf.ecp.view.ideconfig.model.IdeconfigFactory;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ViewEditorIDEViewRootControl
extends ControlRootEClassControl {
    private static final String PLUGIN_ID = "org.eclipse.emf.ecp.ide.editor.view.control";

    protected Object getInput() {
        return this.selectECore();
    }

    private Object selectECore() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IFile file;
                if (selection.length == 1 && selection[0] instanceof IFile && (file = (IFile)selection[0]).getType() == 1) {
                    return new Status(0, ViewEditorIDEViewRootControl.PLUGIN_ID, 0, null, null);
                }
                return new Status(4, ViewEditorIDEViewRootControl.PLUGIN_ID, 4, "Please Select a File", null);
            }
        });
        dialog.setTitle("Select XMI");
        if (dialog.open() == 0) {
            VView view = (VView)this.getFirstSetting().getEObject();
            if (view.getRootEClass() != null) {
                Activator.getViewModelRegistry().unregister(view.getRootEClass().eResource().getURI().toString(), view);
            }
            if (dialog.getFirstResult() instanceof IFile) {
                IFile file = (IFile)dialog.getFirstResult();
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
                Activator.getViewModelRegistry().register(resource.getURI().toString(), (VView)this.getFirstSetting().getEObject().eResource().getContents().get(0));
                try {
                    resource.load(null);
                    EPackage ePackage = (EPackage)resource.getContents().get(0);
                    EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
                    this.persistSelectedEcore(file);
                    return ePackage;
                }
                catch (IOException iOException) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error parsing XMI-File!");
                }
            }
        }
        return null;
    }

    private void persistSelectedEcore(IFile file) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String viewModelPath = this.getFirstSetting().getEObject().eResource().getURI().toString();
        String newModelPath = String.valueOf(viewModelPath.substring(0, viewModelPath.lastIndexOf("."))) + ".ideconfig";
        Resource resource = resourceSet.createResource(URI.createURI((String)newModelPath, (boolean)true));
        IDEConfig config = IdeconfigFactory.eINSTANCE.createIDEConfig();
        config.setEcorePath(file.getFullPath().toString());
        resource.getContents().add((Object)config);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

