/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.handler;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.view.editor.controls.Activator;
import org.eclipse.emf.ecp.view.editor.controls.Helper;
import org.eclipse.emf.ecp.view.editor.handler.ControlGenerator;
import org.eclipse.emf.ecp.view.editor.handler.SelectAttributesDialog;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateControlsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EClass rootClass;
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null) {
            return null;
        }
        ECPProject project = ECPUtil.getECPProjectManager().getProject(selection);
        final SelectAttributesDialog sad = new SelectAttributesDialog(project, rootClass = Helper.getRootEClass((EObject)selection), HandlerUtil.getActiveShell((ExecutionEvent)event));
        int result = sad.open();
        if (result == 0) {
            final Set<EStructuralFeature> featuresToAdd = this.getFeaturesToCreate(sad);
            final VElement compositeCollection = (VElement)selection;
            AdapterFactoryEditingDomain.getEditingDomainFor((EObject)compositeCollection).getCommandStack().execute((Command)new ChangeCommand((Notifier)compositeCollection){

                protected void doExecute() {
                    ControlGenerator.addControls(rootClass, compositeCollection, sad.getDataSegment(), (Set<EStructuralFeature>)featuresToAdd);
                }
            });
        }
        return null;
    }

    private Set<EStructuralFeature> getFeaturesToCreate(SelectAttributesDialog sad) {
        EClass datasegment = sad.getDataSegment();
        Set<EStructuralFeature> features = sad.getSelectedFeatures();
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        HashSet<EStructuralFeature> featuresToAdd = new HashSet<EStructuralFeature>();
        IItemPropertyDescriptor propertyDescriptor = null;
        for (EStructuralFeature feature : features) {
            propertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)EcoreUtil.create((EClass)datasegment), (Object)feature);
            if (propertyDescriptor != null) {
                featuresToAdd.add(feature);
                continue;
            }
            this.logInvalidFeature(feature.getName(), datasegment.getName());
        }
        composedAdapterFactory.dispose();
        return featuresToAdd;
    }

    private void logInvalidFeature(String featureName, String eClassName) {
        String infoMessage = "Feature " + featureName + " of the class " + eClassName + "could not be rendered because it has no property descriptor.";
        ILog log = Activator.getDefault().getLog();
        log.log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.editor.controls", infoMessage));
    }
}

