/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.composites;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.internal.ui.ECPViewerFilter;
import org.eclipse.emf.ecp.internal.ui.composites.AbstractFilteredSelectionComposite;
import org.eclipse.emf.ecp.ui.common.SelectionComposite;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectModelElementCompositeImpl
extends AbstractFilteredSelectionComposite<TableViewer>
implements SelectionComposite<TableViewer> {
    private final ECPViewerFilter filter;
    private final Object input;
    private final ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);

    public SelectModelElementCompositeImpl(Object input) {
        this.filter = new ModelElementViewerFilter((ILabelProvider)this.adapterFactoryLabelProvider);
        this.input = input;
    }

    protected ILabelProvider getLabelProvider() {
        return this.adapterFactoryLabelProvider;
    }

    protected Object getInput() {
        return this.input;
    }

    @Override
    protected ECPViewerFilter getFilter() {
        return this.filter;
    }

    @Override
    protected TableViewer createViewer(Composite composite) {
        TableViewer lv = new TableViewer(composite);
        lv.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        lv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        lv.setInput(this.getInput());
        return lv;
    }

    @Override
    public void dispose() {
        this.composedAdapterFactory.dispose();
        this.adapterFactoryLabelProvider.dispose();
    }

    private final class ModelElementViewerFilter
    extends ECPViewerFilter {
        private final ILabelProvider labelProvider;

        public ModelElementViewerFilter(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.getSearchTerm() == null || this.getSearchTerm().length() == 0) {
                return true;
            }
            if (!(element instanceof EObject)) {
                return false;
            }
            EObject eObjectToFilter = (EObject)element;
            String eObjectName = this.labelProvider.getText((Object)eObjectToFilter);
            String searchString = this.getSearchTerm();
            if (!searchString.startsWith("*")) {
                searchString = "*" + searchString + "*";
            }
            Pattern pattern = Pattern.compile(this.wildcardToRegex(searchString), 2);
            Matcher matcher = pattern.matcher(eObjectName);
            return matcher.matches();
        }

        private String wildcardToRegex(String wildcard) {
            StringBuffer s = new StringBuffer(wildcard.length());
            s.append('^');
            int i = 0;
            int is = wildcard.length();
            while (i < is) {
                char c = wildcard.charAt(i);
                switch (c) {
                    case '*': {
                        s.append(".*");
                        break;
                    }
                    case '?': {
                        s.append(".");
                        break;
                    }
                    case ' ': {
                        s.append("\\s");
                        break;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        s.append("\\");
                        s.append(c);
                        break;
                    }
                    default: {
                        s.append(c);
                    }
                }
                ++i;
            }
            s.append('$');
            return s.toString();
        }
    }
}

