/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.model;

import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextProvider;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.model.IECPLabelProvider;
import org.eclipse.emf.ecp.internal.ui.model.TreeContentProvider;
import org.eclipse.emf.ecp.spi.ui.UIProvider;
import org.eclipse.emf.ecp.spi.ui.UIProviderRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ECPLabelProvider
extends LabelProvider
implements ECPModelContextProvider,
IECPLabelProvider {
    private ECPModelContextProvider modelContextProvider;

    public ECPLabelProvider(ECPModelContextProvider modelContextProvider) {
        this.modelContextProvider = modelContextProvider;
    }

    public String getText(Object element) {
        String text;
        UIProvider uiProvider = this.getUIProvider(element);
        if (uiProvider != null && (text = uiProvider.getText(element)) != null) {
            return text;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        Image image;
        if (element instanceof TreeContentProvider.SlowElement) {
            return Activator.getImage("icons/pending.gif");
        }
        if (element instanceof TreeContentProvider.ErrorElement) {
            return Activator.getImage("icons/error.gif");
        }
        UIProvider uiProvider = this.getUIProvider(element);
        if (uiProvider != null && (image = uiProvider.getImage(element)) != null) {
            return image;
        }
        return super.getImage(element);
    }

    public UIProvider getUIProvider(Object element) {
        ECPContainer modelContext;
        UIProvider uiProvider = UIProviderRegistry.INSTANCE.getUIProvider(element);
        if (uiProvider == null && (modelContext = this.getModelContext(element)) != null) {
            uiProvider = UIProviderRegistry.INSTANCE.getUIProvider(modelContext);
        }
        return uiProvider;
    }

    public ECPContainer getModelContext(Object element) {
        if (this.modelContextProvider != null) {
            return this.modelContextProvider.getModelContext(element);
        }
        return null;
    }

    protected final void fireEvent(final LabelProviderChangedEvent event) {
        Display display = Display.getCurrent();
        if (display == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ECPLabelProvider.this.fireLabelProviderChanged(event);
                }
            });
        } else {
            this.fireLabelProviderChanged(event);
        }
    }

    public ECPModelContextProvider getModelContextProvider() {
        return this.modelContextProvider;
    }

    public void setModelContextProvider(ECPModelContextProvider modelContextProvider) {
        this.modelContextProvider = modelContextProvider;
    }
}

