/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.swt;

import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.DoubleColumnRow;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPControlSWT;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.edit.internal.swt.util.SingleColumnRow;
import org.eclipse.emf.ecp.edit.internal.swt.util.ThreeColumnRow;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.view.internal.custom.swt.Activator;
import org.eclipse.emf.ecp.view.spi.custom.ui.ECPAbstractCustomControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECPAbstractCustomControlSWT
extends ECPAbstractCustomControl
implements ECPControlSWT {
    public static final int VALIDATION_ERROR_IMAGE = 0;
    public static final int ADD_IMAGE = 1;
    public static final int DELETE_IMAGE = 2;
    public static final int HELP_IMAGE = 3;
    private final SWTCustomControlHelper swtHelper = new SWTCustomControlHelper();
    private Label validationLabel;
    private Shell shell;
    private List<RenderingResultRow<Control>> renderingResult;

    protected final Label createValidationLabel(Composite parent) {
        this.validationLabel = new Label(parent, 0);
        this.validationLabel.setBackground(parent.getBackground());
        return this.validationLabel;
    }

    protected final void showError(String title, String message) {
        this.showMessageDialog(1, title, message);
    }

    protected final void showInfo(String title, String message) {
        this.showMessageDialog(2, title, message);
    }

    public final void setMessageShell(Shell shell) {
        this.shell = shell;
    }

    private void showMessageDialog(int type, String title, String message) {
        MessageDialog dialog = new MessageDialog(this.shell, title, null, message, type, new String[]{JFaceResources.getString((String)"ok")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            public void handleResult(int codeResult) {
            }
        }.execute();
    }

    public final List<RenderingResultRow<Control>> createControls(Composite composite) {
        this.renderingResult = this.createControl(composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ECPAbstractCustomControlSWT.this.dispose();
            }
        });
        this.backwardCompatibleHandleValidation();
        return this.renderingResult;
    }

    protected abstract List<RenderingResultRow<Control>> createControl(Composite var1);

    public void setEditable(boolean isEditable) {
        for (RenderingResultRow<Control> row : this.renderingResult) {
            if (SingleColumnRow.class.isInstance(row)) {
                ((SingleColumnRow)row).getControl().setEnabled(isEditable);
                continue;
            }
            if (DoubleColumnRow.class.isInstance(row)) {
                ((DoubleColumnRow)row).getLeftControl().setEnabled(isEditable);
                ((DoubleColumnRow)row).getRightControl().setEnabled(isEditable);
                continue;
            }
            if (!ThreeColumnRow.class.isInstance(row)) continue;
            ((ThreeColumnRow)row).getLeftControl().setEnabled(isEditable);
            ((ThreeColumnRow)row).getRightControl().setEnabled(isEditable);
            ((ThreeColumnRow)row).getMiddleControl().setEnabled(isEditable);
        }
    }

    public final void handleValidation(Diagnostic diagnostic) {
        Diagnostic reason = diagnostic;
        if (diagnostic.getChildren() != null && diagnostic.getChildren().size() != 0) {
            reason = (Diagnostic)diagnostic.getChildren().get(0);
        }
        this.updateValidationColor(this.getValidationBackgroundColor(diagnostic.getSeverity()));
        if (this.validationLabel != null) {
            this.validationLabel.setImage(this.getValidationIcon(diagnostic.getSeverity()));
            this.validationLabel.setToolTipText(reason.getMessage());
            this.validationLabel.setVisible(true);
        }
        List data = diagnostic.getData();
        this.handleCreatedControls(diagnostic);
        this.handleContentValidation(diagnostic.getSeverity(), data.size() > 1 && EStructuralFeature.class.isInstance(data.get(1)) ? data.get(1) : null);
    }

    protected Image getValidationIcon(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationIcon(severity);
    }

    protected Color getValidationBackgroundColor(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationBackgroundColor(severity);
    }

    protected void updateValidationColor(Color color) {
    }

    private void handleCreatedControls(Diagnostic diagnostic) {
        if (diagnostic.getData() == null) {
            return;
        }
        if (diagnostic.getData().size() < 2) {
            return;
        }
        if (!(diagnostic.getData().get(1) instanceof EStructuralFeature)) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)diagnostic.getData().get(1);
        ECPAbstractControl ecpControl = this.getRetrievedControl(feature);
        if (ecpControl == null) {
            return;
        }
        ecpControl.handleValidation(diagnostic);
    }

    protected abstract void handleContentValidation(int var1, EStructuralFeature var2);

    public final void resetValidation() {
        this.resetControlValidation();
        this.updateValidationColor(null);
        if (this.validationLabel != null && !this.validationLabel.isDisposed()) {
            this.validationLabel.setImage(null);
            this.validationLabel.setToolTipText("");
            this.validationLabel.setVisible(false);
        }
        this.resetContentValidation();
    }

    protected abstract void resetContentValidation();

    protected final SWTCustomControlHelper getSWTHelper() {
        return this.swtHelper;
    }

    private Image getImage(int imageType) {
        switch (imageType) {
            case 0: {
                return Activator.getImage("icons/validation_error.png");
            }
            case 3: {
                return Activator.getImage("icons/help.png");
            }
            case 1: {
                return Activator.getImage("icons/add.png");
            }
            case 2: {
                return Activator.getImage("icons/delete.png");
            }
        }
        return null;
    }

    protected final Composite createControl(VDomainModelReference domainModelReference, Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        SWTControl control = (SWTControl)this.getControl(SWTControl.class, domainModelReference);
        List createControls = control.createControls(composite);
        RenderingResultRow row = (RenderingResultRow)createControls.get(0);
        if (DoubleColumnRow.class.isInstance(row)) {
            ((DoubleColumnRow)row).getLeftControl().setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).hint(16, 17).create());
            ((DoubleColumnRow)row).getRightControl().setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        }
        return composite;
    }

    public final void dispose() {
        if (this.validationLabel != null) {
            this.validationLabel.dispose();
            this.validationLabel = null;
        }
        super.dispose();
    }

    protected void createViewerBinding(VDomainModelReference customControlFeature, StructuredViewer viewer, IValueProperty[] labelProperties) {
        IObservableList list = this.getObservableList(customControlFeature);
        ViewerSupport.bind((StructuredViewer)viewer, (IObservableList)list, (IValueProperty[])labelProperties);
    }

    public final class SWTCustomControlHelper {
        public Image getImage(int imageType) {
            return ECPAbstractCustomControlSWT.this.getImage(imageType);
        }
    }
}

