/**
 * Copyright (c) 2011-2013 EclipseSource Muenchen GmbH and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Eugen Neufeld - initial API and implementation
 */
package org.eclipse.emf.ecp.view.spi.label.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Style</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * 
 * @see org.eclipse.emf.ecp.view.spi.label.model.VLabelPackage#getVLabelStyle()
 * @model
 * @generated
 * @since 1.2
 */
public enum VLabelStyle implements Enumerator
{
	/**
	 * The '<em><b>H0</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H0_VALUE
	 * @generated
	 * @ordered
	 */
	H0(0, "H0", "H0"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H1</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H1_VALUE
	 * @generated
	 * @ordered
	 */
	H1(1, "H1", "H1"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H2</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H2_VALUE
	 * @generated
	 * @ordered
	 */
	H2(2, "H2", "H2"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H3</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H3_VALUE
	 * @generated
	 * @ordered
	 */
	H3(3, "H3", "H3"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H4_VALUE
	 * @generated
	 * @ordered
	 */
	H4(4, "H4", "H4"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H5</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H5_VALUE
	 * @generated
	 * @ordered
	 */
	H5(5, "H5", "H5"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H6_VALUE
	 * @generated
	 * @ordered
	 */
	H6(6, "H6", "H6"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H7</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H7_VALUE
	 * @generated
	 * @ordered
	 */
	H7(7, "H7", "H7"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H8</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H8_VALUE
	 * @generated
	 * @ordered
	 */
	H8(8, "H8", "H8"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H9</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #H9_VALUE
	 * @generated
	 * @ordered
	 */
	H9(9, "H9", "H9"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>Separator</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #SEPARATOR_VALUE
	 * @generated
	 * @ordered
	 */
	SEPARATOR(10, "Separator", "Separator"); //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>H0</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H0</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H0
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H0_VALUE = 0;

	/**
	 * The '<em><b>H1</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H1</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H1
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H1_VALUE = 1;

	/**
	 * The '<em><b>H2</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H2</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H2
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H2_VALUE = 2;

	/**
	 * The '<em><b>H3</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H3</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H3
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H3_VALUE = 3;

	/**
	 * The '<em><b>H4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H4</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H4
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H4_VALUE = 4;

	/**
	 * The '<em><b>H5</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H5</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H5
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H5_VALUE = 5;

	/**
	 * The '<em><b>H6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H6</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H6
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H6_VALUE = 6;

	/**
	 * The '<em><b>H7</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H7</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H7
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H7_VALUE = 7;

	/**
	 * The '<em><b>H8</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H8</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H8
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H8_VALUE = 8;

	/**
	 * The '<em><b>H9</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>H9</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #H9
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int H9_VALUE = 9;

	/**
	 * The '<em><b>Separator</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Separator</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #SEPARATOR
	 * @model name="Separator"
	 * @generated
	 * @ordered
	 */
	public static final int SEPARATOR_VALUE = 10;

	/**
	 * An array of all the '<em><b>VLabel Style</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static final VLabelStyle[] VALUES_ARRAY =
		new VLabelStyle[]
		{
			H0,
			H1,
			H2,
			H3,
			H4,
			H5,
			H6,
			H7,
			H8,
			H9,
			SEPARATOR,
		};

	/**
	 * A public read-only list of all the '<em><b>VLabel Style</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static final List<VLabelStyle> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>VLabel Style</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static VLabelStyle get(String literal)
	{
		for (int i = 0; i < VALUES_ARRAY.length; ++i)
		{
			final VLabelStyle result = VALUES_ARRAY[i];
			if (result.toString().equals(literal))
			{
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>VLabel Style</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static VLabelStyle getByName(String name)
	{
		for (int i = 0; i < VALUES_ARRAY.length; ++i)
		{
			final VLabelStyle result = VALUES_ARRAY[i];
			if (result.getName().equals(name))
			{
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>VLabel Style</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static VLabelStyle get(int value)
	{
		switch (value)
		{
		case H0_VALUE:
			return H0;
		case H1_VALUE:
			return H1;
		case H2_VALUE:
			return H2;
		case H3_VALUE:
			return H3;
		case H4_VALUE:
			return H4;
		case H5_VALUE:
			return H5;
		case H6_VALUE:
			return H6;
		case H7_VALUE:
			return H7;
		case H8_VALUE:
			return H8;
		case H9_VALUE:
			return H9;
		case SEPARATOR_VALUE:
			return SEPARATOR;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private VLabelStyle(int value, String name, String literal)
	{
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public int getValue()
	{
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getLiteral()
	{
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString()
	{
		return literal;
	}

} // LabelStyle
