/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainModelReferenceIterator
implements Iterator<EStructuralFeature.Setting> {
    private final EStructuralFeature domainModelFeature;
    private final List<ReferenceCounter> references;
    private final EObject lastResolvedEObject;
    private boolean hasNext;

    public DomainModelReferenceIterator(List<EReference> leftReferences, EObject lastResolvedEObject, EStructuralFeature domainModelFeature) {
        this.domainModelFeature = domainModelFeature;
        this.lastResolvedEObject = lastResolvedEObject;
        ArrayList<ReferenceCounter> referenceCounters = new ArrayList<ReferenceCounter>(leftReferences.size());
        for (EReference eReference : leftReferences) {
            ReferenceCounter rc = new ReferenceCounter();
            rc.eReference = eReference;
            rc.position = 0;
            referenceCounters.add(rc);
        }
        this.references = referenceCounters;
        this.hasNext = this.resolveRefernces();
    }

    @Override
    public void remove() {
    }

    @Override
    public EStructuralFeature.Setting next() {
        if (this.lastResolvedEObject == null) {
            return null;
        }
        EObject current = this.lastResolvedEObject;
        this.hasNext = this.references.size() != 0;
        int i = 0;
        while (i < this.references.size()) {
            EObject child;
            ReferenceCounter referenceCounter = this.references.get(i);
            EReference eReference = referenceCounter.eReference;
            if (!current.eClass().getEAllStructuralFeatures().contains((Object)eReference)) {
                return null;
            }
            if (!eReference.isMany()) {
                child = (EObject)current.eGet((EStructuralFeature)eReference);
            } else {
                List children = (List)current.eGet((EStructuralFeature)eReference);
                if (children == null || children.size() == 0) {
                    throw new IllegalStateException("The EReference " + eReference.getName() + " is wrong for " + current.eClass().getName() + "!");
                }
                child = (EObject)children.get(referenceCounter.position);
                if (i + 1 == this.references.size()) {
                    ReferenceCounter referenceCounter2 = referenceCounter;
                    referenceCounter2.position = referenceCounter2.position + 1;
                    if (referenceCounter.position == children.size()) {
                        this.increaseCounter(i - 1);
                    }
                }
            }
            if (child == null) {
                throw new IllegalStateException("EObject in reference" + eReference.getName() + " of EObject " + current.eClass().getName() + " not set!");
            }
            current = child;
            ++i;
        }
        if (!current.eClass().getEAllStructuralFeatures().contains((Object)this.domainModelFeature)) {
            return null;
        }
        return ((InternalEObject)current).eSetting(this.domainModelFeature);
    }

    private void increaseCounter(int currentPosition) {
        if (currentPosition < 0) {
            this.hasNext = false;
            return;
        }
        ReferenceCounter previousCounter = this.references.get(currentPosition);
        if (!previousCounter.eReference.isMany()) {
            this.increaseCounter(currentPosition - 1);
        } else {
            ReferenceCounter referenceCounter = previousCounter;
            referenceCounter.position = referenceCounter.position + 1;
            int numElements = this.calculateSizeOfElementsOnPosition(currentPosition);
            if (previousCounter.position == numElements) {
                this.increaseCounter(currentPosition - 1);
            } else {
                int j = currentPosition + 1;
                while (j < this.references.size()) {
                    this.references.get(j).position = 0;
                    ++j;
                }
            }
        }
    }

    private int calculateSizeOfElementsOnPosition(int position) {
        EObject current = this.lastResolvedEObject;
        int j = 0;
        while (j < position) {
            EObject child;
            ReferenceCounter referenceCounter = this.references.get(j);
            EReference eReference = referenceCounter.eReference;
            if (!eReference.isMany()) {
                child = (EObject)current.eGet((EStructuralFeature)eReference);
            } else {
                List children = (List)current.eGet((EStructuralFeature)eReference);
                int id = referenceCounter.position;
                child = (EObject)children.get(id);
            }
            current = child;
            ++j;
        }
        return ((List)current.eGet((EStructuralFeature)this.references.get(position).eReference)).size();
    }

    private boolean resolveRefernces() {
        EObject current = this.lastResolvedEObject;
        if (this.lastResolvedEObject == null) {
            return false;
        }
        int i = 0;
        while (i < this.references.size()) {
            EObject child;
            ReferenceCounter referenceCounter = this.references.get(i);
            EReference eReference = referenceCounter.eReference;
            if (!current.eClass().getEAllStructuralFeatures().contains((Object)eReference)) {
                return false;
            }
            if (!eReference.isMany()) {
                child = (EObject)current.eGet((EStructuralFeature)eReference);
            } else {
                List children = (List)current.eGet((EStructuralFeature)eReference);
                if (children == null || children.size() == 0) {
                    return false;
                }
                child = (EObject)children.get(0);
            }
            if (child == null) {
                return false;
            }
            current = child;
            ++i;
        }
        return current != null && current.eClass().getEAllStructuralFeatures().contains((Object)this.domainModelFeature);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    private class ReferenceCounter {
        private EReference eReference;
        private int position;

        private ReferenceCounter() {
        }
    }
}

