/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTRenderingHelper;
import org.eclipse.emf.ecp.internal.ui.view.emf.AdapterFactoryContentProvider;
import org.eclipse.emf.ecp.internal.ui.view.emf.AdapterFactoryLabelProvider;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.treemasterdetail.model.VTreeMasterDetail;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.Activator;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.ecp.CreateChildAction;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMasterDetailSWTRenderer
extends AbstractSWTRenderer<VTreeMasterDetail> {
    public static final String GLOBAL_ADDITIONS = "global_additions";

    protected List<RenderingResultRow<Control>> renderModel(Composite parent, VTreeMasterDetail vElement, ViewModelContext viewContext) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        SashForm sash = new SashForm(parent, 256);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo((Composite)sash);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)sash);
        sash.setSashWidth(5);
        Composite leftPanel = new Composite((Composite)sash, 4);
        leftPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(1, 4).grab(false, true).applyTo((Control)leftPanel);
        leftPanel.setBackground(parent.getBackground());
        ScrolledComposite rightPanel = new ScrolledComposite((Composite)sash, 2816);
        rightPanel.setShowFocusedControl(true);
        rightPanel.setExpandVertical(true);
        rightPanel.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)rightPanel);
        rightPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        rightPanel.setBackground(parent.getBackground());
        sash.setWeights(new int[]{1, 3});
        EObject modelElement = viewContext.getDomainModel();
        VView detailView = vElement.getDetailView();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)modelElement);
        final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public Object[] getElements(Object object) {
                return new Object[]{((RootObject)object).getRoot()};
            }
        };
        final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        TreeViewer treeViewer = new TreeViewer(leftPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(100, -1).applyTo((Control)treeViewer.getTree());
        treeViewer.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)adapterFactoryLabelProvider);
        treeViewer.setInput((Object)new RootObject(modelElement));
        this.addDragAndDropSupport(modelElement, treeViewer, editingDomain);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeMasterViewSelectionListener(rightPanel, detailView));
        this.fillContextMenu(treeViewer, editingDomain);
        RenderingResultRow createRenderingResultRow = SWTRenderingHelper.INSTANCE.getResultRowFactory().createRenderingResultRow((Object[])new Control[]{parent});
        ArrayList<RenderingResultRow<Control>> renderingList = new ArrayList<RenderingResultRow<Control>>();
        renderingList.add(createRenderingResultRow);
        treeViewer.getTree().addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                adapterFactoryContentProvider.dispose();
                adapterFactoryLabelProvider.dispose();
                adapterFactory.dispose();
            }
        });
        return renderingList;
    }

    private void addDragAndDropSupport(EObject modelElement, TreeViewer treeViewer, EditingDomain editingDomain) {
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        treeViewer.addDragSupport(7, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)treeViewer));
        EditingDomainViewerDropAdapter editingDomainViewerDropAdapter = new EditingDomainViewerDropAdapter(editingDomain, (Viewer)treeViewer);
        treeViewer.addDropSupport(7, transfers, (DropTargetListener)editingDomainViewerDropAdapter);
    }

    private void fillContextMenu(final TreeViewer treeViewer, final EditingDomain editingDomain) {
        final ChildrenDescriptorCollector childrenDescriptorCollector = new ChildrenDescriptorCollector();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (treeViewer.getSelection().isEmpty()) {
                    return;
                }
                Object root = ((RootObject)treeViewer.getInput()).getRoot();
                if (treeViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                    if (selection.size() == 1) {
                        EObject eObject = (EObject)selection.getFirstElement();
                        Collection descriptors = childrenDescriptorCollector.getDescriptors(eObject);
                        TreeMasterDetailSWTRenderer.this.fillContextMenu(manager, descriptors, editingDomain, eObject);
                    }
                    if (!selection.toList().contains(root)) {
                        manager.add((IContributionItem)new Separator(TreeMasterDetailSWTRenderer.GLOBAL_ADDITIONS));
                        TreeMasterDetailSWTRenderer.this.addDeleteActionToContextMenu(editingDomain, manager, selection);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager, Collection<?> descriptors, final EditingDomain domain, final EObject eObject) {
        for (Object descriptor : descriptors) {
            final CommandParameter cp = (CommandParameter)descriptor;
            if (!CommandParameter.class.isInstance(descriptor) || cp.getEReference() == null || !cp.getEReference().isMany() && eObject.eIsSet(cp.getEStructuralFeature()) || cp.getEReference().isMany() && cp.getEReference().getUpperBound() != -1 && cp.getEReference().getUpperBound() <= ((List)eObject.eGet((EStructuralFeature)cp.getEReference())).size()) continue;
            manager.add((IAction)new CreateChildAction(domain, (ISelection)new StructuredSelection((Object)eObject), descriptor){

                public void run() {
                    super.run();
                    EReference reference = ((CommandParameter)this.descriptor).getEReference();
                    domain.getCommandStack().execute(AddCommand.create((EditingDomain)domain, (Object)eObject, (Object)reference, (Object)cp.getEValue()));
                }
            });
        }
    }

    private void addDeleteActionToContextMenu(final EditingDomain editingDomain, IMenuManager manager, final IStructuredSelection selection) {
        Action deleteAction = new Action(){

            public void run() {
                super.run();
                for (Object obj : selection.toList()) {
                    editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, obj));
                }
            }
        };
        deleteAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/delete.png")));
        manager.add((IAction)deleteAction);
    }

    private class RootObject {
        private final EObject modelElement;

        public RootObject(EObject modelElement) {
            this.modelElement = modelElement;
        }

        public Object getRoot() {
            return this.modelElement;
        }
    }

    private class TreeMasterViewSelectionListener
    implements ISelectionChangedListener {
        private final ScrolledComposite parent;
        private Composite childComposite;
        private final VView vView;

        public TreeMasterViewSelectionListener(ScrolledComposite rightPanel, VView vView) {
            this.parent = rightPanel;
            this.vView = vView;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selected instanceof EObject) {
                try {
                    if (this.childComposite != null) {
                        this.childComposite.dispose();
                    }
                    this.childComposite = this.createComposite((Composite)this.parent);
                    this.parent.setContent((Control)this.childComposite);
                    Object root = ((RootObject)((TreeViewer)event.getSource()).getInput()).getRoot();
                    if (selected.equals(root)) {
                        ECPSWTViewRenderer.INSTANCE.render(this.childComposite, (EObject)selected, this.vView);
                    } else {
                        ECPSWTViewRenderer.INSTANCE.render(this.childComposite, (EObject)selected);
                    }
                    this.parent.layout();
                    this.childComposite.layout();
                    Point point = this.childComposite.computeSize(-1, -1);
                    this.parent.setMinSize(point);
                }
                catch (ECPRendererException ex) {
                    ex.printStackTrace();
                }
            }
        }

        private Composite createComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getBackground());
            GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
            return composite;
        }
    }
}

