/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRegistry {
    private final Map<UniqueSetting, Set<VControl>> domainObjectToAffectedControls;
    private final Set<VElement> processedRenderables = new LinkedHashSet<VElement>();
    private Map<VElement, Set<UniqueSetting>> controlToDomainMapping = new LinkedHashMap<VElement, Set<UniqueSetting>>();

    public ValidationRegistry() {
        this.domainObjectToAffectedControls = new LinkedHashMap<UniqueSetting, Set<VControl>>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
    }

    public void register(EObject domainModel, VElement renderable) {
        Map<UniqueSetting, Set<VControl>> domainToControlMapping = this.getDomainToControlMapping(domainModel, renderable);
        this.fillMap(domainToControlMapping, this.domainObjectToAffectedControls);
    }

    public Map<UniqueSetting, Set<VControl>> getDomainToControlMapping(EObject domainModel, VElement renderable) {
        this.processedRenderables.add(renderable);
        if (renderable.getDiagnostic() == null) {
            renderable.setDiagnostic(VViewFactory.eINSTANCE.createDiagnostic());
        }
        LinkedHashMap<UniqueSetting, Set<VControl>> result = new LinkedHashMap<UniqueSetting, Set<VControl>>();
        if (VControl.class.isInstance(renderable)) {
            VControl control = (VControl)renderable;
            VDomainModelReference domainModelReference = control.getDomainModelReference();
            if (domainModelReference == null) {
                return result;
            }
            Iterator iterator = domainModelReference.getIterator();
            while (iterator.hasNext()) {
                UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)((EStructuralFeature.Setting)iterator.next()));
                if (!result.containsKey(uniqueSetting)) {
                    result.put(uniqueSetting, new LinkedHashSet());
                }
                ((Set)result.get(uniqueSetting)).add(control);
            }
        } else {
            for (EObject eObject : renderable.eContents()) {
                if (!VElement.class.isInstance(eObject)) continue;
                this.fillMap(this.getDomainToControlMapping(domainModel, (VElement)eObject), result);
            }
        }
        return result;
    }

    public EObject resolveDomainModel(EObject domainModel, List<EReference> references) {
        EObject referencedDomainModel = domainModel;
        for (EReference eReference : references) {
            if (!eReference.getEContainingClass().isInstance((Object)referencedDomainModel)) continue;
            EObject child = (EObject)referencedDomainModel.eGet((EStructuralFeature)eReference);
            if (child == null) {
                child = EcoreUtil.create((EClass)eReference.getEReferenceType());
                referencedDomainModel.eSet((EStructuralFeature)eReference, (Object)child);
            }
            referencedDomainModel = child;
        }
        return referencedDomainModel;
    }

    private void fillMap(Map<UniqueSetting, Set<VControl>> source, Map<UniqueSetting, Set<VControl>> target) {
        for (UniqueSetting domainSource : source.keySet()) {
            Set<VControl> controlSet = source.get(domainSource);
            this.fillMapEntry(target, domainSource, controlSet);
        }
    }

    private void fillMapEntry(Map<UniqueSetting, Set<VControl>> target, UniqueSetting domainSource, Set<VControl> controlSet) {
        for (VControl abstractControl : controlSet) {
            Set<UniqueSetting> set = this.controlToDomainMapping.get(abstractControl);
            if (set == null) {
                this.controlToDomainMapping.put((VElement)abstractControl, new LinkedHashSet());
            }
            this.controlToDomainMapping.get(abstractControl).add(domainSource);
        }
        if (!target.containsKey(domainSource)) {
            target.put(domainSource, controlSet);
        } else {
            target.get(domainSource).addAll(controlSet);
        }
    }

    public void addEObjectControlMapping(EStructuralFeature.Setting domainObject, VControl control) {
        LinkedHashSet<VControl> controlSet = new LinkedHashSet<VControl>();
        controlSet.add(control);
        this.fillMapEntry(this.domainObjectToAffectedControls, UniqueSetting.createSetting((EStructuralFeature.Setting)domainObject), controlSet);
    }

    public void removeRenderable(VElement renderable) {
        Set<UniqueSetting> eObjects = this.controlToDomainMapping.get(renderable);
        if (eObjects != null) {
            for (UniqueSetting eObject : eObjects) {
                Set<VControl> set = this.domainObjectToAffectedControls.get(eObject);
                if (set == null || !set.contains(renderable)) continue;
                this.domainObjectToAffectedControls.get(eObject).remove(renderable);
            }
        }
        this.controlToDomainMapping.remove(renderable);
        this.processedRenderables.remove(renderable);
    }

    public Set<VControl> removeDomainObject(EObject domainObject) {
        LinkedHashSet<VControl> allRemovedControls = new LinkedHashSet<VControl>();
        for (EStructuralFeature feature : domainObject.eClass().getEAllStructuralFeatures()) {
            UniqueSetting uniqueSetting = UniqueSetting.createSetting((EObject)domainObject, (EStructuralFeature)feature);
            Set<VControl> set = this.domainObjectToAffectedControls.remove(uniqueSetting);
            if (set == null) continue;
            for (VControl control : set) {
                if (this.controlToDomainMapping.get(control).size() != 1) continue;
                allRemovedControls.add(control);
            }
        }
        for (VControl abstractControl : allRemovedControls) {
            this.controlToDomainMapping.remove(abstractControl);
        }
        return allRemovedControls;
    }

    public Set<VControl> getRenderablesForEObject(EStructuralFeature.Setting model) {
        if (!this.domainObjectToAffectedControls.containsKey(UniqueSetting.createSetting((EStructuralFeature.Setting)model))) {
            return Collections.emptySet();
        }
        return this.domainObjectToAffectedControls.get(UniqueSetting.createSetting((EStructuralFeature.Setting)model));
    }

    public boolean containsRenderable(VElement renderable) {
        return this.processedRenderables.contains(renderable);
    }

    public void updateMappings(EObject newEObject) {
        EObject parent = newEObject.eContainer();
        if (parent == null) {
            return;
        }
        EStructuralFeature.Setting parentSetting = ((InternalEObject)parent).eSetting((EStructuralFeature)newEObject.eContainmentFeature());
        UniqueSetting parentUniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)parentSetting);
        if (!this.domainObjectToAffectedControls.containsKey(parentUniqueSetting)) {
            return;
        }
        Set<VControl> set = this.domainObjectToAffectedControls.get(parentUniqueSetting);
        for (VControl vControl : set) {
            Iterator iterator = vControl.getDomainModelReference().getIterator();
            while (iterator.hasNext()) {
                EStructuralFeature.Setting controlSetting = (EStructuralFeature.Setting)iterator.next();
                if (!controlSetting.getEObject().equals(newEObject)) continue;
                this.register(newEObject, (VElement)vControl);
            }
        }
    }

    public boolean containsVElementForEObject(EObject eObject) {
        for (EStructuralFeature esf : eObject.eClass().getEAllStructuralFeatures()) {
            if (!this.domainObjectToAffectedControls.containsKey(UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)esf))) continue;
            return true;
        }
        return false;
    }
}

