/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.validation.Activator;
import org.eclipse.emf.ecp.view.internal.validation.ValidationNotification;
import org.eclipse.emf.ecp.view.internal.validation.ValidationProvider;
import org.eclipse.emf.ecp.view.internal.validation.ValidationRegistry;
import org.eclipse.emf.ecp.view.internal.validation.ViewValidationListener;
import org.eclipse.emf.ecp.view.internal.validation.ViewValidator;
import org.eclipse.emf.ecp.view.spi.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationService
implements ViewModelService {
    private ViewModelContext context;
    private VElement renderable;
    private ViewModelContext.ModelChangeListener domainChangeListener;
    private ViewModelContext.ModelChangeListener viewChangeListener;
    private ViewValidator viewValidationGraph;
    private ValidationRegistry validationRegistry;
    private final List<ViewValidationListener> validationListener;
    private final Set<ValidationProvider> validationProviders = new LinkedHashSet<ValidationProvider>();

    public ValidationService() {
        this.validationListener = new ArrayList<ViewValidationListener>();
    }

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.renderable = context.getViewModel();
        if (this.renderable == null) {
            throw new IllegalStateException("View model must not be null");
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException("Domain model must not be null");
        }
        this.readValidationProvider();
        this.domainChangeListener = new DomainModelChangeListener(domainModel);
        this.viewChangeListener = new ViewModelChangeListener(domainModel);
        context.registerDomainChangeListener(this.domainChangeListener);
        context.registerViewChangeListener(this.viewChangeListener);
        this.init(this.renderable, domainModel);
        this.viewValidationGraph.validate(this.getAllEObjects(domainModel));
        this.notifyListeners();
    }

    private void readValidationProvider() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.validation.validationProvider");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ValidationProvider validationProvider = (ValidationProvider)e.createExecutableExtension("class");
                this.validationProviders.add(validationProvider);
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
            ++n2;
        }
    }

    private void init(VElement view, EObject domainModel) {
        this.validationRegistry = new ValidationRegistry();
        this.validationRegistry.register(domainModel, view);
        this.viewValidationGraph = new ViewValidator(view, domainModel, this.validationRegistry, this.validationProviders);
    }

    private Collection<EObject> getAllEObjects(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(eObject);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)false);
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    public void registerValidationListener(ViewValidationListener listener) {
        this.validationListener.add(listener);
        listener.onNewValidation(this.getDiagnosticResult());
    }

    public void deregisterValidationListener(ViewValidationListener listener) {
        this.validationListener.remove(listener);
    }

    private void notifyListeners() {
        if (this.validationListener.size() > 0) {
            Set<Diagnostic> result = this.getDiagnosticResult();
            for (ViewValidationListener l : this.validationListener) {
                l.onNewValidation(result);
            }
        }
    }

    private Set<Diagnostic> getDiagnosticResult() {
        LinkedHashSet<Diagnostic> result = new LinkedHashSet<Diagnostic>();
        if (this.renderable.getDiagnostic().getHighestSeverity() > 0) {
            for (Object o : this.renderable.getDiagnostic().getDiagnostics()) {
                if (((Diagnostic)o).getSeverity() <= 0) continue;
                result.add((Diagnostic)o);
            }
        }
        return result;
    }

    public void dispose() {
        this.context.unregisterDomainChangeListener(this.domainChangeListener);
        this.context.unregisterViewChangeListener(this.viewChangeListener);
    }

    public Set<VDiagnostic> getAllDiagnostics(EObject domainObject) {
        return this.viewValidationGraph.getAllValues(domainObject);
    }

    public Map<EStructuralFeature, VDiagnostic> getDiagnosticPerFeature(EObject domainObject) {
        return this.viewValidationGraph.getValuePerFeature(domainObject);
    }

    public int getPriority() {
        return 3;
    }

    public void addValidationProvider(ValidationProvider validationProvider) {
        this.validationProviders.add(validationProvider);
        this.viewValidationGraph.validate(this.getAllEObjects(this.context.getDomainModel()));
    }

    public void removeValidationProvider(ValidationProvider validationProvider) {
        this.validationProviders.remove(validationProvider);
        this.viewValidationGraph.validate(this.getAllEObjects(this.context.getDomainModel()));
    }

    class DomainModelChangeListener
    implements ViewModelContext.ModelChangeListener {
        private final EObject domainModel;

        public DomainModelChangeListener(EObject domainModel) {
            this.domainModel = domainModel;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (ValidationService.this.viewValidationGraph == null) {
                return;
            }
            if (ValidationNotification.class.isInstance(notification.getRawNotification())) {
                ValidationService.this.viewValidationGraph.validate(ValidationService.this.getAllEObjects(notification.getNotifier()));
                return;
            }
            Notification rawNotification = notification.getRawNotification();
            switch (rawNotification.getEventType()) {
                case 3: 
                case 4: {
                    ValidationService.this.viewValidationGraph.validate(ValidationService.this.getAllEObjects(notification.getNotifier()));
                    break;
                }
                case 5: 
                case 6: {
                    ValidationService.this.viewValidationGraph.validate(ValidationService.this.getAllEObjects(this.domainModel));
                    break;
                }
                default: {
                    ValidationService.this.viewValidationGraph.validate(ValidationService.this.getAllEObjects(notification.getNotifier()));
                }
            }
            ValidationService.this.notifyListeners();
        }

        public void notifyAdd(Notifier notifier) {
            if (ValidationService.this.viewValidationGraph != null) {
                EObject eObject = (EObject)notifier;
                ValidationService.this.validationRegistry.updateMappings(eObject);
                if (!ValidationService.this.validationRegistry.containsVElementForEObject(eObject)) {
                    ValidationService.this.validationRegistry.register(eObject, ValidationService.this.renderable);
                }
                ValidationService.this.viewValidationGraph.validate(eObject);
            }
        }

        public void notifyRemove(Notifier notifier) {
            EObject eObject = (EObject)notifier;
            ValidationService.this.viewValidationGraph.removeDomainObject(eObject);
            Set<VControl> removedControls = ValidationService.this.validationRegistry.removeDomainObject(eObject);
            for (VControl vControl : removedControls) {
                ValidationService.this.viewValidationGraph.removeRenderable((VElement)vControl);
            }
        }
    }

    class ViewModelChangeListener
    implements ViewModelContext.ModelChangeListener {
        private final EObject domainModel;

        public ViewModelChangeListener(EObject domainModel) {
            this.domainModel = domainModel;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (!(!VElement.class.isInstance(notification.getRawNotification().getNotifier()) || notification.getRawNotification().getFeature() == VViewPackage.eINSTANCE.getElement_Diagnostic() || EReference.class.isInstance(notification.getRawNotification().getFeature()) && VElement.class.isInstance(notification.getRawNotification().getNewValue()) || VViewPackage.eINSTANCE.getElement_Enabled() != notification.getRawNotification().getFeature() && VViewPackage.eINSTANCE.getElement_Visible() != notification.getRawNotification().getFeature() || VViewPackage.eINSTANCE.getControl() != notification.getNotifier().eClass())) {
                VControl control = (VControl)notification.getNotifier();
                VDomainModelReference domainModelReference = control.getDomainModelReference();
                Iterator settings = domainModelReference.getIterator();
                while (settings.hasNext()) {
                    ValidationService.this.viewValidationGraph.validate(((EStructuralFeature.Setting)settings.next()).getEObject());
                }
            }
        }

        public void notifyAdd(Notifier notifier) {
            VElement renderable;
            EObject renderableParent;
            if (VElement.class.isInstance(notifier) && VElement.class.isInstance(renderableParent = (renderable = (VElement)notifier).eContainer()) && ValidationService.this.validationRegistry.containsRenderable((VElement)renderableParent)) {
                ValidationService.this.validationRegistry.register(this.domainModel, renderable);
                Map<UniqueSetting, Set<VControl>> map = ValidationService.this.validationRegistry.getDomainToControlMapping(this.domainModel, renderable);
                ValidationService.this.viewValidationGraph.validateSettings(map.keySet());
            }
        }

        public void notifyRemove(Notifier notifier) {
            if (VElement.class.isInstance(notifier)) {
                ValidationService.this.validationRegistry.removeRenderable((VElement)notifier);
                ValidationService.this.viewValidationGraph.removeRenderable((VElement)notifier);
            }
        }
    }
}

