/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.validation.SettingsNodeMapping;
import org.eclipse.emf.ecp.view.internal.validation.ViewModelGraphNode;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewModelGraph {
    private final SettingsNodeMapping viewModelSettings;
    private final SettingsNodeMapping domainModelSettings;
    private final EObject domainModel;

    public ViewModelGraph(VElement viewModel, EObject domainModel, Comparator<VDiagnostic> comparator) {
        this.domainModel = domainModel;
        this.viewModelSettings = new SettingsNodeMapping(comparator);
        this.domainModelSettings = new SettingsNodeMapping(comparator);
        this.buildRenderableNodes((EObject)viewModel);
    }

    private void buildRenderableNodes(EObject viewModel) {
        EList eContents = viewModel.eContents();
        ViewModelGraphNode parentNode = this.viewModelSettings.createNode(viewModel, SettingsNodeMapping.allFeatures(), this.getDefaultValue(), false);
        for (EObject content : eContents) {
            if (!VElement.class.isInstance(content)) continue;
            ViewModelGraphNode childNode = this.viewModelSettings.createNode(content, SettingsNodeMapping.allFeatures(), this.getDefaultValue(), false);
            parentNode.addChild(childNode);
            this.buildRenderableNodes(content);
        }
    }

    public abstract VDiagnostic getDefaultValue();

    public VDiagnostic getValue(VElement renderable) {
        return this.viewModelSettings.getNode((EObject)renderable, SettingsNodeMapping.allFeatures()).getValue();
    }

    public Set<VDiagnostic> getAllValues(EObject domainObject) {
        LinkedHashSet<VDiagnostic> result = new LinkedHashSet<VDiagnostic>();
        Set<ViewModelGraphNode> allNodes = this.domainModelSettings.getAllNodes(domainObject);
        for (ViewModelGraphNode viewModelGraphNode : allNodes) {
            result.add(viewModelGraphNode.getValue());
        }
        return result;
    }

    public Map<EStructuralFeature, VDiagnostic> getValuePerFeature(EObject domainObject) {
        LinkedHashMap<EStructuralFeature, VDiagnostic> result = new LinkedHashMap<EStructuralFeature, VDiagnostic>();
        Set<ViewModelGraphNode> allNodes = this.domainModelSettings.getAllNodes(domainObject);
        for (ViewModelGraphNode viewModelGraphNode : allNodes) {
            result.put(viewModelGraphNode.getSetting().getEStructuralFeature(), viewModelGraphNode.getValue());
        }
        return result;
    }

    public void update(VElement renderable, EObject domainObject, EStructuralFeature feature, VDiagnostic value) {
        Set<ViewModelGraphNode> parentNodes = this.updateNodes(renderable, domainObject, feature, value);
        for (ViewModelGraphNode cachedNode : parentNodes) {
            this.updateParentNodes(cachedNode);
        }
    }

    private Set<EObject> updateParentNodes(ViewModelGraphNode node) {
        LinkedHashSet<EObject> updated = new LinkedHashSet<EObject>();
        Set<ViewModelGraphNode> nodes = node.getParents();
        this.updateRenderable((VElement)node.getSetting().getEObject());
        for (ViewModelGraphNode cachedNode : nodes) {
            updated.addAll(this.updateParentNodes(cachedNode));
        }
        return updated;
    }

    public void removeDomainObject(EObject domainObject) {
        EList eAllStructuralFeatures = domainObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eAllStructuralFeatures) {
            ViewModelGraphNode node = this.domainModelSettings.getNode(domainObject, eStructuralFeature);
            if (node == null) continue;
            this.removeChildFromParents(node);
        }
        this.domainModelSettings.removeAll(domainObject);
    }

    private void removeChildFromParents(ViewModelGraphNode childNode) {
        LinkedHashSet<ViewModelGraphNode> parentNodes = new LinkedHashSet<ViewModelGraphNode>(childNode.getParents());
        for (ViewModelGraphNode oldParent : parentNodes) {
            oldParent.removeChild(childNode);
        }
    }

    public void removeRenderable(VElement renderable) {
        ViewModelGraphNode node = this.viewModelSettings.getNode((EObject)renderable, SettingsNodeMapping.allFeatures());
        if (node != null) {
            Set<ViewModelGraphNode> parents = node.getParents();
            for (ViewModelGraphNode parentNode : new LinkedHashSet<ViewModelGraphNode>(parents)) {
                parentNode.removeChild(node);
                this.updateParentNodes(parentNode);
            }
            node.removeAllChildren();
        }
        this.viewModelSettings.removeAll((EObject)renderable);
    }

    protected void updateRenderable(VElement renderable) {
    }

    private Set<ViewModelGraphNode> updateNodes(VElement renderable, EObject domainObject, EStructuralFeature feature, VDiagnostic value) {
        LinkedHashSet<ViewModelGraphNode> affectedParentNodes = new LinkedHashSet<ViewModelGraphNode>();
        ViewModelGraphNode renderableNode = this.getNodeForRenderable(renderable);
        ViewModelGraphNode domainNode = this.getNodeForDomainObject(domainObject, feature, value);
        affectedParentNodes.add(renderableNode);
        if (this.domainObjectHasBeenRemoved(domainObject, feature)) {
            this.removeChildFromParents(domainNode);
            return affectedParentNodes;
        }
        if (!renderableNode.containsChild(domainNode)) {
            renderableNode.addChild(domainNode);
        }
        domainNode.setValue(value);
        return affectedParentNodes;
    }

    private ViewModelGraphNode getNodeForDomainObject(EObject domainObject, EStructuralFeature feature, VDiagnostic value) {
        ViewModelGraphNode node = this.domainModelSettings.getNode(domainObject, feature);
        if (node == null) {
            node = this.domainModelSettings.createNode(domainObject, feature, value, true);
        }
        return node;
    }

    private boolean domainObjectHasBeenRemoved(EObject domainObject, EStructuralFeature feature) {
        ViewModelGraphNode node = this.domainModelSettings.getNode(domainObject, feature);
        return node.isDomainObject() && !this.isDomainModelElement(domainObject);
    }

    private ViewModelGraphNode getNodeForRenderable(VElement renderable) {
        ViewModelGraphNode node = this.viewModelSettings.getNode((EObject)renderable, SettingsNodeMapping.allFeatures());
        if (node == null) {
            node = this.viewModelSettings.createNode((EObject)renderable, SettingsNodeMapping.allFeatures(), this.getDefaultValue(), false);
            EObject eContainer = renderable.eContainer();
            ViewModelGraphNode possibleParent = this.viewModelSettings.getNode(eContainer, SettingsNodeMapping.allFeatures());
            if (possibleParent == null) {
                possibleParent = this.getNodeForRenderable((VElement)eContainer);
            }
            possibleParent.addChild(node);
        }
        return node;
    }

    private boolean isDomainModelElement(EObject possibleChild) {
        return this.isContainedInModel(this.domainModel, possibleChild);
    }

    private boolean isContainedInModel(EObject root, EObject possibleChild) {
        if (root == possibleChild) {
            return true;
        }
        EObject container = possibleChild;
        while (container != null) {
            if (container == root) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }
}

