/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.edit.internal.swt.util.DoubleColumnRow;
import org.eclipse.emf.ecp.edit.internal.swt.util.SingleColumnRow;
import org.eclipse.emf.ecp.edit.internal.swt.util.ThreeColumnRow;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTViewRenderer
extends AbstractSWTRenderer<VView> {
    public static final SWTViewRenderer INSTANCE = new SWTViewRenderer();

    protected List<RenderingResultRow<Control>> renderModel(Composite parent, VView vView, ViewModelContext viewContext) throws NoPropertyDescriptorFoundExeption, NoRendererFoundException {
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(columnComposite);
        for (VContainedElement child : vView.getChildren()) {
            List resultRows;
            try {
                resultRows = SWTRendererFactory.INSTANCE.render(columnComposite, (VElement)child, viewContext);
            }
            catch (NoPropertyDescriptorFoundExeption ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.core.swt", ex.getMessage(), (Throwable)ex));
                continue;
            }
            catch (NoRendererFoundException ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.ecp.view.core.swt", ex.getMessage(), (Throwable)ex));
                continue;
            }
            if (resultRows == null) continue;
            this.setLayoutDataForResultRows(resultRows);
        }
        return this.createResult(new Control[]{columnComposite});
    }

    protected void setLayoutDataForResultRows(List<RenderingResultRow<Control>> resultRows) {
        for (RenderingResultRow<Control> row : resultRows) {
            if (SingleColumnRow.class.isInstance(row)) {
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(3, 1).applyTo(((SingleColumnRow)row).getControl());
                continue;
            }
            if (DoubleColumnRow.class.isInstance(row)) {
                GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo(((DoubleColumnRow)row).getLeftControl());
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo(((DoubleColumnRow)row).getRightControl());
                continue;
            }
            if (!ThreeColumnRow.class.isInstance(row)) continue;
            GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo(((ThreeColumnRow)row).getLeftControl());
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).hint(16, 17).applyTo(((ThreeColumnRow)row).getMiddleControl());
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(((ThreeColumnRow)row).getRightControl());
        }
    }
}

