/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.e4.view;

import javax.annotation.PostConstruct;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.swt.modeling.EMenuService;
import org.eclipse.emf.ecp.ui.common.TreeViewerFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class ECPRepositoryView {
    private static final String POPUPMENU_REPOSITORY = "org.eclipse.emf.ecp.e4.application.popupmenu.repository";
    private TreeViewer repositoryTree;

    @PostConstruct
    public void create(Composite composite, EMenuService menuService, final ESelectionService selectionService) {
        this.repositoryTree = TreeViewerFactory.createRepositoryExplorerViewer((Composite)composite, null);
        menuService.registerContextMenu((Object)this.repositoryTree.getTree(), POPUPMENU_REPOSITORY);
        this.repositoryTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (IStructuredSelection.class.isInstance(selection)) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection != null && !structuredSelection.isEmpty()) {
                        if (structuredSelection.size() == 1) {
                            selectionService.setSelection(structuredSelection.getFirstElement());
                        } else {
                            selectionService.setSelection((Object)structuredSelection.toList());
                        }
                    } else {
                        selectionService.setSelection(null);
                    }
                }
            }
        });
    }

    @Focus
    public void setFocus() {
        this.repositoryTree.getTree().setFocus();
    }
}

