/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.context;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.view.internal.context.Activator;
import org.eclipse.emf.ecp.view.spi.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewModelContextImpl
implements ViewModelContext {
    private static final String NO_VIEW_SERVICE_OF_TYPE_FOUND = "No view service of type '%1$s' found.";
    private static final String MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL = "ModelChangeListener must not be null.";
    private static final String THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED = "The ViewModelContext was already disposed.";
    private final VElement view;
    private final EObject domainObject;
    private final List<ViewModelContext.ModelChangeListener> viewModelChangeListener = new CopyOnWriteArrayList<ViewModelContext.ModelChangeListener>();
    private final List<ViewModelContext.ModelChangeListener> domainModelChangeListener = new ArrayList<ViewModelContext.ModelChangeListener>();
    private EContentAdapter domainModelContentAdapter;
    private EContentAdapter viewModelContentAdapter;
    private final SortedSet<ViewModelService> viewServices = new TreeSet<ViewModelService>(new Comparator<ViewModelService>(){

        @Override
        public int compare(ViewModelService arg0, ViewModelService arg1) {
            return arg0.getPriority() - arg1.getPriority();
        }
    });
    private boolean isDisposed;
    private boolean isDisposing;

    public ViewModelContextImpl(VElement view, EObject domainObject) {
        this.view = view;
        this.domainObject = domainObject;
        this.instantiate();
    }

    public ViewModelContextImpl(VElement view, EObject domainObject, ViewModelService ... modelServices) {
        this.view = view;
        this.domainObject = domainObject;
        ViewModelService[] viewModelServiceArray = modelServices;
        int n = modelServices.length;
        int n2 = 0;
        while (n2 < n) {
            ViewModelService vms = viewModelServiceArray[n2];
            this.viewServices.add(vms);
            ++n2;
        }
        this.instantiate();
    }

    private void instantiate() {
        ViewModelUtil.resolveDomainReferences((VElement)this.getViewModel(), (EObject)this.getDomainModel());
        this.viewModelContentAdapter = new ViewModelContentAdapter();
        this.view.eAdapters().add((Object)this.viewModelContentAdapter);
        this.domainModelContentAdapter = new DomainModelContentAdapter();
        this.domainObject.eAdapters().add((Object)this.domainModelContentAdapter);
        this.readAbstractViewServices();
        for (ViewModelService viewService : this.viewServices) {
            viewService.instantiate(this);
        }
    }

    private void readAbstractViewServices() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.context.viewServices");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ViewModelService viewService = (ViewModelService)e.createExecutableExtension("class");
                this.viewServices.add(viewService);
            }
            catch (CoreException e1) {
                Activator.log(e1);
            }
            ++n2;
        }
    }

    @Override
    public VElement getViewModel() {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        return this.view;
    }

    @Override
    public EObject getDomainModel() {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        return this.domainObject;
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposing = true;
        this.view.eAdapters().remove((Object)this.viewModelContentAdapter);
        this.domainObject.eAdapters().remove((Object)this.domainModelContentAdapter);
        this.viewModelChangeListener.clear();
        this.domainModelChangeListener.clear();
        for (ViewModelService viewService : this.viewServices) {
            viewService.dispose();
        }
        this.viewServices.clear();
        this.isDisposing = false;
        this.isDisposed = true;
    }

    @Override
    public void registerViewChangeListener(ViewModelContext.ModelChangeListener modelChangeListener) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException(MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL);
        }
        this.viewModelChangeListener.add(modelChangeListener);
    }

    @Override
    public void unregisterViewChangeListener(ViewModelContext.ModelChangeListener modelChangeListener) {
        this.viewModelChangeListener.remove(modelChangeListener);
    }

    @Override
    public void registerDomainChangeListener(ViewModelContext.ModelChangeListener modelChangeListener) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException(MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL);
        }
        this.domainModelChangeListener.add(modelChangeListener);
    }

    @Override
    public void unregisterDomainChangeListener(ViewModelContext.ModelChangeListener modelChangeListener) {
        this.domainModelChangeListener.remove(modelChangeListener);
    }

    @Override
    public <T> boolean hasService(Class<T> serviceType) {
        for (ViewModelService service : this.viewServices) {
            if (!serviceType.isInstance(service)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getService(Class<T> serviceType) {
        for (ViewModelService service : this.viewServices) {
            if (!serviceType.isInstance(service)) continue;
            return (T)service;
        }
        Activator.log(new IllegalArgumentException(String.format(NO_VIEW_SERVICE_OF_TYPE_FOUND, serviceType.getCanonicalName())));
        return null;
    }

    private class DomainModelContentAdapter
    extends EContentAdapter {
        private DomainModelContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            if (notification.isTouch()) {
                return;
            }
            ModelChangeNotification modelChangeNotification = new ModelChangeNotification(notification);
            for (ViewModelContext.ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                modelChangeListener.notifyChange(modelChangeNotification);
            }
        }

        protected void addAdapter(Notifier notifier) {
            super.addAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            for (ViewModelContext.ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                modelChangeListener.notifyAdd(notifier);
            }
        }

        protected void removeAdapter(Notifier notifier) {
            super.removeAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            for (ViewModelContext.ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                modelChangeListener.notifyRemove(notifier);
            }
        }
    }

    private class ViewModelContentAdapter
    extends EContentAdapter {
        private ViewModelContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            if (notification.isTouch()) {
                return;
            }
            ModelChangeNotification modelChangeNotification = new ModelChangeNotification(notification);
            for (ViewModelContext.ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                modelChangeListener.notifyChange(modelChangeNotification);
            }
        }

        protected void addAdapter(Notifier notifier) {
            super.addAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            if (VElement.class.isInstance(notifier)) {
                ViewModelUtil.resolveDomainReferences((VElement)((VElement)notifier), (EObject)ViewModelContextImpl.this.getDomainModel());
            }
            for (ViewModelContext.ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                modelChangeListener.notifyAdd(notifier);
            }
        }

        protected void removeAdapter(Notifier notifier) {
            super.removeAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            for (ViewModelContext.ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                modelChangeListener.notifyRemove(notifier);
            }
        }
    }
}

