/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.ui;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.view.internal.custom.ui.Activator;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPCustomControlChangeListener;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPHardcodedReferences;
import org.eclipse.emf.ecp.view.spi.custom.model.VHardcodedDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECPAbstractCustomControl
extends ECPAbstractControl
implements ECPHardcodedReferences {
    private final CustomControlHelper helper = new CustomControlHelper();
    private final ECPControlFactory controlFactory;
    private final Map<EStructuralFeature, ECPAbstractControl> controlMap = new LinkedHashMap<EStructuralFeature, ECPAbstractControl>();
    private final Map<VDomainModelReference, Adapter> adapterMap = new LinkedHashMap<VDomainModelReference, Adapter>();

    public ECPAbstractCustomControl() {
        this.controlFactory = Activator.getECPControlFactory();
    }

    protected final List<VDomainModelReference> getResolvedDomainModelReferences() {
        VHardcodedDomainModelReference hardcodedDomainModelReference = (VHardcodedDomainModelReference)this.getDomainModelReference();
        return hardcodedDomainModelReference.getDomainModelReferences();
    }

    protected final VDomainModelReference getResolvedDomainModelReference(EStructuralFeature feature) {
        VHardcodedDomainModelReference hardcodedDomainModelReference = (VHardcodedDomainModelReference)this.getDomainModelReference();
        for (VDomainModelReference domainModelReference : hardcodedDomainModelReference.getDomainModelReferences()) {
            VFeaturePathDomainModelReference ref;
            if (!VFeaturePathDomainModelReference.class.isInstance(domainModelReference) || (ref = (VFeaturePathDomainModelReference)domainModelReference).getDomainModelEFeature() != feature) continue;
            return ref;
        }
        return null;
    }

    protected final ECPAbstractControl getRetrievedControl(EStructuralFeature eStructuralFeature) {
        return this.controlMap.get(eStructuralFeature);
    }

    protected final void resetControlValidation() {
        Set<EStructuralFeature> keySet = this.controlMap.keySet();
        for (EStructuralFeature eStructuralFeature : keySet) {
            ECPAbstractControl ecpControl = this.controlMap.get(eStructuralFeature);
            ecpControl.resetValidation();
        }
    }

    protected Binding bindTargetToModel(VDomainModelReference modelFeature, IObservableValue targetValue, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        EStructuralFeature.Setting setting = this.getFirstSetting(modelFeature);
        IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(setting), (EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature());
        return this.getDataBindingContext().bindValue(targetValue, modelValue, targetToModel, modelToTarget);
    }

    protected IObservableList getObservableList(VDomainModelReference domainModelReference) {
        EStructuralFeature.Setting setting = this.getFirstSetting(domainModelReference);
        return EMFEditObservables.observeList((EditingDomain)this.getEditingDomain(setting), (EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature());
    }

    protected void setValue(VDomainModelReference modelReference, Object newValue) {
        EStructuralFeature.Setting setting = this.getFirstSetting(modelReference);
        setting.set(newValue);
    }

    protected void registerChangeListener(VDomainModelReference modelReference, final ECPCustomControlChangeListener changeListener) {
        if (this.adapterMap.containsKey(modelReference)) {
            return;
        }
        final EStructuralFeature.Setting setting = this.getFirstSetting(modelReference);
        AdapterImpl newAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.isTouch()) {
                    return;
                }
                if (msg.getFeature().equals(setting.getEStructuralFeature())) {
                    super.notifyChanged(msg);
                    changeListener.notifyChanged();
                }
            }
        };
        setting.getEObject().eAdapters().add((Object)newAdapter);
        this.adapterMap.put(modelReference, (Adapter)newAdapter);
    }

    protected Object getValue(VDomainModelReference modelReference) {
        EStructuralFeature.Setting setting = this.getFirstSetting(modelReference);
        return setting.get(false);
    }

    private EStructuralFeature.Setting getFirstSetting(VDomainModelReference modelFeature) {
        Iterator iterator = modelFeature.getIterator();
        int numElments = 0;
        EStructuralFeature.Setting setting = null;
        while (iterator.hasNext()) {
            setting = (EStructuralFeature.Setting)iterator.next();
            ++numElments;
        }
        if (numElments == 0) {
            throw new IllegalStateException("The VDomainModelReference was not initialised.");
        }
        if (numElments > 1) {
            throw new IllegalStateException("The VDomainModelReference is ambigous, please use VDomainModelReference which resolve to exactly one setting.");
        }
        return setting;
    }

    protected final IItemPropertyDescriptor getItemPropertyDescriptor(VDomainModelReference domainModelReference) {
        return this.getItemPropertyDescriptor(this.getFirstSetting(domainModelReference));
    }

    private String getHelp(VDomainModelReference domainModelReference) {
        if (!this.getResolvedDomainModelReferences().contains(domainModelReference)) {
            throw new IllegalArgumentException("The feature must have been registered before!");
        }
        return this.getItemPropertyDescriptor(domainModelReference).getDescription(null);
    }

    private String getLabel(VDomainModelReference domainModelReference) {
        if (!this.getResolvedDomainModelReferences().contains(domainModelReference)) {
            throw new IllegalArgumentException("The feature must have been registered before!");
        }
        return this.getItemPropertyDescriptor(domainModelReference).getDisplayName(null);
    }

    @Deprecated
    public final boolean showLabel() {
        return false;
    }

    public void dispose() {
        Activator.ungetECPControlFactory();
        for (VDomainModelReference domainModelReference : this.adapterMap.keySet()) {
            EStructuralFeature.Setting setting = this.getFirstSetting(domainModelReference);
            setting.getEObject().eAdapters().remove((Object)this.adapterMap.get(domainModelReference));
        }
        this.disposeCustomControl();
    }

    protected abstract void disposeCustomControl();

    protected final CustomControlHelper getHelper() {
        return this.helper;
    }

    protected final <T extends ECPAbstractControl> T getControl(Class<T> clazz, VDomainModelReference domainModelReference) {
        ECPAbstractControl createControl = (ECPAbstractControl)this.controlFactory.createControl(clazz, domainModelReference);
        VControl vControl = VViewFactory.eINSTANCE.createControl();
        vControl.setDomainModelReference(domainModelReference);
        vControl.setDiagnostic(VViewFactory.eINSTANCE.createDiagnostic());
        createControl.init(this.getViewModelContext(), vControl);
        Iterator iterator = domainModelReference.getIterator();
        boolean hasNext = iterator.hasNext();
        if (hasNext) {
            this.controlMap.put(((EStructuralFeature.Setting)iterator.next()).getEStructuralFeature(), createControl);
            return (T)createControl;
        }
        return null;
    }

    public final class CustomControlHelper {
        public String getHelp(VDomainModelReference domainModelReference) {
            return ECPAbstractCustomControl.this.getHelp(domainModelReference);
        }

        public String getLabel(VDomainModelReference domainModelReference) {
            return ECPAbstractCustomControl.this.getLabel(domainModelReference);
        }
    }
}

