/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.util;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.impl.Activator;

public final class ViewModelUtil {
    private ViewModelUtil() {
    }

    public static void resolveDomainReferences(VElement renderable, EObject domainModelRoot) {
        ViewModelUtil.checkAndResolve(renderable, domainModelRoot);
        TreeIterator eAllContents = renderable.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            ViewModelUtil.checkAndResolve(eObject, domainModelRoot);
        }
    }

    private static void checkAndResolve(EObject renderable, EObject domainModelRoot) {
        if (VControl.class.isInstance(renderable)) {
            VControl control = (VControl)renderable;
            if (control.getDomainModelReference() == null) {
                return;
            }
            boolean resolve = control.getDomainModelReference().resolve(domainModelRoot);
            if (!resolve) {
                Activator.logMessage(2, "Not resolved: " + control.getDomainModelReference() + " on control " + control);
            }
        }
    }
}

