/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.provider.xmi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecp.internal.view.model.provider.xmi.Activator;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewModelFileExtensionsManager {
    private static final String FILE_EXTENSION = "org.eclipse.emf.ecp.view.model.provider.xmi.file";
    private static final String FILEPATH_ATTRIBUTE = "filePath";
    private final Map<EClass, VView> map = new HashMap<EClass, VView>();
    private static ViewModelFileExtensionsManager instance;

    private ViewModelFileExtensionsManager() {
    }

    public static ViewModelFileExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ViewModelFileExtensionsManager();
            instance.init();
        }
        return instance;
    }

    private void init() {
        List<URI> extensionURIS = ViewModelFileExtensionsManager.getExtensionURIS();
        for (URI uri : extensionURIS) {
            VView view;
            Resource resource = ViewModelFileExtensionsManager.loadResource(uri);
            EObject eObject = (EObject)resource.getContents().get(0);
            if (!(eObject instanceof VView) || (view = (VView)eObject).getRootEClass() == null) continue;
            this.map.put(view.getRootEClass(), view);
        }
    }

    public static Resource loadResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://org/eclipse/emf/ecp/view/model", (Object)VViewPackage.eINSTANCE);
        Resource resource = resourceSet.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException exception) {
            Activator.log(exception);
        }
        return resource;
    }

    public static void dispose() {
        instance = null;
    }

    public static List<URI> getExtensionURIS() {
        ArrayList<URI> ret = new ArrayList<URI>();
        IConfigurationElement[] files = Platform.getExtensionRegistry().getConfigurationElementsFor(FILE_EXTENSION);
        URIConverter converter = new ResourceSetImpl().getURIConverter();
        IConfigurationElement[] iConfigurationElementArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement file = iConfigurationElementArray[n2];
            String filePath = file.getAttribute(FILEPATH_ATTRIBUTE);
            String bundleName = file.getContributor().getName();
            String path = String.valueOf(bundleName) + '/' + filePath;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            if (converter.exists(uri, null)) {
                ret.add(uri);
            } else {
                uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
                if (converter.exists(uri, null)) {
                    ret.add(uri);
                }
            }
            ++n2;
        }
        return ret;
    }

    public boolean hasViewModelFor(EObject eObject) {
        return this.map.containsKey(eObject.eClass());
    }

    public VView createView(EObject eObject) {
        return (VView)EcoreUtil.copy((EObject)this.map.get(eObject.eClass()));
    }
}

