/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.cachetree.IExcludedObjectsCallback;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.internal.validation.ValidationService;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.validation.api.IValidationService;
import org.eclipse.emf.ecp.validation.api.IValidationServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationServiceProvider
implements IValidationServiceProvider {
    private Map<Object, IValidationService> mapping = new HashMap<Object, IValidationService>();

    @Override
    public IValidationService getValidationService(final Object validationServiceObject) {
        if (!this.mapping.containsKey(validationServiceObject)) {
            ValidationService validationService = new ValidationService(new IExcludedObjectsCallback(){

                public boolean isExcluded(Object object) {
                    if (InternalProject.class.isInstance(validationServiceObject)) {
                        return ((InternalProject)validationServiceObject).isModelRoot(object);
                    }
                    return false;
                }
            });
            this.mapping.put(validationServiceObject, validationService);
            if (validationServiceObject instanceof ECPProject) {
                ECPProject project = (ECPProject)validationServiceObject;
                validationService.validate(this.getAllChildEObjects(project));
            }
            return validationService;
        }
        return this.mapping.get(validationServiceObject);
    }

    private Collection<EObject> getAllChildEObjects(ECPProject project) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object object : project.getContents()) {
            if (!EObject.class.isInstance(object)) continue;
            EObject eObject = (EObject)object;
            result.add(eObject);
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)false);
            while (iterator.hasNext()) {
                result.add((EObject)iterator.next());
            }
        }
        return result;
    }

    @Override
    public void deleteValidationService(Object key) {
        this.mapping.remove(key);
    }
}

