/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.internal.e3;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecp.editor.internal.e3.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PageCandidate {
    private List<PageCandidate> replacedBy = new LinkedList<PageCandidate>();
    private List<PageCandidate> successors = new LinkedList<PageCandidate>();
    private IConfigurationElement page;
    private boolean enqueued;
    private static Map<String, PageCandidate> candidates = new LinkedHashMap<String, PageCandidate>();

    public static List<IConfigurationElement> getPages(IConfigurationElement[] input) {
        IConfigurationElement[] iConfigurationElementArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement i = iConfigurationElementArray[n2];
            new PageCandidate(i);
            ++n2;
        }
        PageCandidate.linkPages();
        List<PageCandidate> orderedPages = PageCandidate.determineOrder();
        candidates.clear();
        LinkedList<IConfigurationElement> result = new LinkedList<IConfigurationElement>();
        for (PageCandidate p : orderedPages) {
            result.add(p.page);
        }
        return result;
    }

    private PageCandidate(IConfigurationElement page) {
        this.page = page;
        String name = page.getAttribute("name");
        if (candidates.containsKey(name)) {
            Activator.logException(new Exception("Two pages to be added to the MEEditor have the same name (" + name + ")! One of them will not be visible."));
        }
        candidates.put(name, this);
    }

    private static void linkPages() {
        for (Map.Entry<String, PageCandidate> curEntry : candidates.entrySet()) {
            PageCandidate before;
            String after;
            PageCandidate cur = curEntry.getValue();
            String r = cur.page.getAttribute("replace");
            if (r != null) {
                String[] replacements;
                String[] stringArray = replacements = r.split(",");
                int n = replacements.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    PageCandidate replaced = candidates.get(s.trim());
                    if (replaced != null) {
                        replaced.replacedBy.add(cur);
                    }
                    ++n2;
                }
            }
            if ((after = cur.page.getAttribute("after")) == null || (before = candidates.get(after)) == null) continue;
            before.successors.add(cur);
        }
    }

    private void enqueue(List<PageCandidate> l) {
        if (this.enqueued) {
            return;
        }
        if (this.replacedBy.size() != 0) {
            for (PageCandidate c : this.replacedBy) {
                c.enqueue(l);
            }
        } else {
            l.add(this);
            this.enqueued = true;
        }
        for (PageCandidate c : this.successors) {
            c.enqueue(l);
        }
    }

    private static List<PageCandidate> determineOrder() {
        LinkedList<PageCandidate> result = new LinkedList<PageCandidate>();
        for (Map.Entry<String, PageCandidate> e : candidates.entrySet()) {
            PageCandidate p = e.getValue();
            if (p.successors.size() != 0 || p.replacedBy.size() != 0) continue;
            p.enqueue(result);
        }
        return result;
    }
}

