/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextProvider;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.model.ModelContentProvider;
import org.eclipse.emf.ecp.internal.ui.util.ECPHandlerHelper;
import org.eclipse.emf.ecp.spi.ui.UIProvider;
import org.eclipse.emf.ecp.spi.ui.UIProviderRegistry;
import org.eclipse.emf.ecp.ui.common.TreeViewerFactory;
import org.eclipse.emf.ecp.ui.linkedView.ILinkedWithEditorView;
import org.eclipse.emf.ecp.ui.linkedView.LinkedWithEditorPartListener;
import org.eclipse.emf.ecp.ui.platform.Activator;
import org.eclipse.emf.ecp.ui.tester.SaveButtonEnablementObserver;
import org.eclipse.emf.ecp.ui.views.TreeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class ModelExplorerView
extends TreeView
implements ILinkedWithEditorView {
    private static final String LINK_WITH_EDITOR_SET = "LinkWithEditorSet";
    private static final String LINK_WITH_EDITOR = "LinkWithEditor";
    public static final String ID = "org.eclipse.emf.ecp.ui.ModelExplorerView";
    private final IPartListener2 linkWithEditorPartListener = new LinkedWithEditorPartListener(this);
    private boolean linkingActive = true;
    private ModelContentProvider contentProvider;
    private TreeViewer viewer;
    private Action linkWithEditorAction;

    public ModelExplorerView() {
        super(ID);
    }

    protected TreeViewer createViewer(Composite parent) {
        this.viewer = TreeViewerFactory.createModelExplorerViewer((Composite)parent, (boolean)true, (ILabelDecorator)this.createLabelDecorator());
        this.contentProvider = (ModelContentProvider)this.viewer.getContentProvider();
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new ModelExplorerViewSelectionListener());
        this.viewer.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
            }

            public void focusLost(FocusEvent event) {
                ((SaveButtonEnablementObserver)ECPUtil.getECPObserverBus().notify(SaveButtonEnablementObserver.class)).notifyChangeButtonState(null, false);
            }
        });
        IConfigurationElement[] modelExplorerSettings = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.ui.modelExplorerSettings");
        if (modelExplorerSettings.length == 1 && modelExplorerSettings[0].getAttribute("viewSorter") != null) {
            try {
                ViewerSorter sorter = (ViewerSorter)modelExplorerSettings[0].createExecutableExtension("viewSorter");
                this.viewer.setSorter(sorter);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return this.viewer;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.getDialogSettings().getBoolean(LINK_WITH_EDITOR_SET)) {
            this.linkingActive = this.getDialogSettings().getBoolean(LINK_WITH_EDITOR);
        }
        if (this.linkingActive) {
            this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
        }
        this.linkWithEditorAction = new Action("Link with editor", 2){

            public void run() {
                if (ModelExplorerView.this.linkingActive) {
                    ModelExplorerView.this.linkingActive = false;
                    ModelExplorerView.this.getSite().getPage().removePartListener(ModelExplorerView.this.linkWithEditorPartListener);
                } else {
                    ModelExplorerView.this.linkingActive = true;
                    ModelExplorerView.this.getSite().getPage().addPartListener(ModelExplorerView.this.linkWithEditorPartListener);
                    IEditorPart editor = ModelExplorerView.this.getSite().getPage().getActiveEditor();
                    if (editor != null) {
                        ModelExplorerView.this.editorActivated(editor);
                    }
                }
                ModelExplorerView.this.getDialogSettings().put(ModelExplorerView.LINK_WITH_EDITOR, this.isChecked());
                ModelExplorerView.this.getDialogSettings().put(ModelExplorerView.LINK_WITH_EDITOR_SET, true);
            }
        };
        this.linkWithEditorAction.setImageDescriptor(Activator.getImageDescriptor("icons/link_with_editor.gif"));
        this.linkWithEditorAction.setToolTipText("Link with editor");
        this.linkWithEditorAction.setChecked(this.getDialogSettings().getBoolean(LINK_WITH_EDITOR_SET) ? this.getDialogSettings().getBoolean(LINK_WITH_EDITOR) : true);
        manager.add((IAction)this.linkWithEditorAction);
    }

    private IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected void fillContextMenu(IMenuManager manager) {
        UIProvider provider;
        Object[] elements = this.getSelection().toArray();
        ECPContainer context = ECPUtil.getModelContext((ECPModelContextProvider)this.contentProvider, (Object[])elements);
        if (context != null && (provider = UIProviderRegistry.INSTANCE.getUIProvider((Object)context)) != null) {
            provider.fillContextMenu(manager, context, elements);
        }
        super.fillContextMenu(manager);
    }

    public void editorActivated(IEditorPart activatedEditor) {
        if (!this.linkingActive || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        Object input = activatedEditor.getEditorInput().getAdapter(EObject.class);
        if (input != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(input), true);
        }
    }

    public class DoubleClickListener
    implements IDoubleClickListener {
        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof ECPProject) {
                    ECPProject project = (ECPProject)firstElement;
                    if (!project.isOpen()) {
                        project.open();
                    }
                } else {
                    ECPContainer context = ECPUtil.getModelContext((ECPModelContextProvider)ModelExplorerView.this.contentProvider, (Object[])structuredSelection.toArray());
                    ECPHandlerHelper.openModelElement((Object)firstElement, (ECPProject)((ECPProject)context));
                }
            }
        }
    }

    private class ModelExplorerViewSelectionListener
    implements ISelectionChangedListener {
        private ModelExplorerViewSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selected;
            this.notifyAboutSaveButtonState(event);
            if (ModelExplorerView.this.linkingActive && (selected = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof EObject) {
                IEditorReference[] iEditorReferenceArray = ModelExplorerView.this.getSite().getPage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorRef = iEditorReferenceArray[n2];
                    Object editorInput = null;
                    try {
                        editorInput = editorRef.getEditorInput().getAdapter(EObject.class);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    if (selected.equals(editorInput)) {
                        ModelExplorerView.this.getSite().getPage().bringToTop(editorRef.getPart(true));
                        return;
                    }
                    ++n2;
                }
            }
        }

        private void notifyAboutSaveButtonState(SelectionChangedEvent event) {
            Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
            ECPProject project = ECPUtil.getECPProjectManager().getProject(selected);
            boolean selectedProjectIsDirty = project == null ? false : project.hasDirtyContents();
            ((SaveButtonEnablementObserver)ECPUtil.getECPObserverBus().notify(SaveButtonEnablementObserver.class)).notifyChangeButtonState(project, selectedProjectIsDirty);
        }
    }
}

