/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;

public final class VDiagnosticHelper {
    private VDiagnosticHelper() {
    }

    public static boolean isEqual(VDiagnostic vDiagnostic1, VDiagnostic vDiagnostic2) {
        if (vDiagnostic1 == null && vDiagnostic2 == null) {
            return true;
        }
        if (vDiagnostic1 == null && vDiagnostic2 != null) {
            return false;
        }
        if (vDiagnostic2 == null && vDiagnostic1 != null) {
            return false;
        }
        if (vDiagnostic1.getHighestSeverity() != vDiagnostic2.getHighestSeverity()) {
            return false;
        }
        if (!vDiagnostic1.getMessage().equals(vDiagnostic2.getMessage())) {
            return false;
        }
        int i = 0;
        while (i < vDiagnostic1.getDiagnostics().size()) {
            Diagnostic diagnostic2;
            Diagnostic diagnostic1 = (Diagnostic)vDiagnostic1.getDiagnostics().get(i);
            if (!VDiagnosticHelper.areUnderlyingDiagnosticsEqual(diagnostic1, diagnostic2 = (Diagnostic)vDiagnostic2.getDiagnostics().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean areUnderlyingDiagnosticsEqual(Diagnostic diagnostic1, Diagnostic diagnostic2) {
        if (diagnostic1.getSeverity() != diagnostic2.getSeverity()) {
            return false;
        }
        if (diagnostic1.getData().size() != diagnostic2.getData().size()) {
            return false;
        }
        if (diagnostic1.getChildren().size() != diagnostic2.getChildren().size()) {
            return false;
        }
        int j = 0;
        while (j < diagnostic1.getData().size()) {
            Object data2;
            Object data1 = diagnostic1.getData().get(j);
            if (!data1.equals(data2 = diagnostic2.getData().get(j))) {
                return false;
            }
            ++j;
        }
        int i = 0;
        while (i < diagnostic1.getChildren().size()) {
            if (!VDiagnosticHelper.areUnderlyingDiagnosticsEqual((Diagnostic)diagnostic1.getChildren().get(i), (Diagnostic)diagnostic2.getChildren().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

