/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewModelGraphNode {
    private final VDiagnostic initValue;
    private final Set<ViewModelGraphNode> parents;
    private final UniqueSetting setting;
    private final Set<ViewModelGraphNode> children;
    private final boolean isDomainObject;
    private VDiagnostic value;

    public ViewModelGraphNode(UniqueSetting setting, VDiagnostic value, boolean isDomainObject, Comparator<VDiagnostic> comparator) {
        this.setting = setting;
        this.value = value;
        this.initValue = value;
        this.isDomainObject = isDomainObject;
        this.parents = new LinkedHashSet<ViewModelGraphNode>();
        this.children = new LinkedHashSet<ViewModelGraphNode>();
    }

    public VDiagnostic getValue() {
        if (this.isLocked()) {
            return this.initValue;
        }
        if (this.hasChildren()) {
            VDiagnostic result = VViewFactory.eINSTANCE.createDiagnostic();
            for (ViewModelGraphNode child : this.children) {
                result.getDiagnostics().addAll((Collection)child.getValue().getDiagnostics());
            }
            return result;
        }
        return this.value;
    }

    public boolean isLocked() {
        VElement renderable;
        return this.isRenderable() && (!(renderable = (VElement)this.getSetting().getEObject()).isEnabled() || !renderable.isVisible() || renderable.isReadonly());
    }

    private boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void addChild(ViewModelGraphNode childNode) {
        childNode.addParent(this);
        this.addToChildrenQueue(childNode);
    }

    public void removeChild(ViewModelGraphNode childNode) {
        this.children.remove(childNode);
        childNode.getParents().remove(this);
        if (!this.hasChildren()) {
            this.value = this.initValue;
        }
    }

    public void removeAllChildren() {
        for (ViewModelGraphNode childNode : this.children) {
            childNode.getParents().remove(this);
            if (this.hasChildren()) continue;
            this.value = this.initValue;
        }
        this.children.clear();
    }

    public void setValue(VDiagnostic value) {
        this.value = value;
        for (ViewModelGraphNode parent : this.getParents()) {
            parent.addToChildrenQueue(this);
            parent.setValue(parent.getValue());
        }
    }

    public Set<ViewModelGraphNode> getParents() {
        return this.parents;
    }

    private void addParent(ViewModelGraphNode parent) {
        this.parents.add(parent);
    }

    private void addToChildrenQueue(ViewModelGraphNode childNode) {
        this.children.remove(childNode);
        this.children.add(childNode);
    }

    public boolean isDomainObject() {
        return this.isDomainObject;
    }

    public boolean isRenderable() {
        return !this.isDomainObject && VElement.class.isInstance(this.getSetting().getEObject());
    }

    public boolean containsChild(ViewModelGraphNode node) {
        return this.children.contains(node);
    }

    public UniqueSetting getSetting() {
        return this.setting;
    }

    public Iterator<ViewModelGraphNode> getChildren() {
        return this.children.iterator();
    }
}

