/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.validation.VDiagnosticHelper;
import org.eclipse.emf.ecp.view.internal.validation.ValidationProvider;
import org.eclipse.emf.ecp.view.internal.validation.ValidationRegistry;
import org.eclipse.emf.ecp.view.internal.validation.ViewModelGraph;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewValidator
extends ViewModelGraph {
    private final Queue<EObject> validationQueue = new LinkedList<EObject>();
    private final ValidationRegistry validationRegistry;
    private boolean validationRunning;
    private final Set<ValidationProvider> validationProviders;

    public ViewValidator(VElement viewModel, EObject domainModel, ValidationRegistry validationRegistry, Set<ValidationProvider> validationProviders) {
        super(viewModel, domainModel, new Comparator<VDiagnostic>(){

            @Override
            public int compare(VDiagnostic vDiagnostic1, VDiagnostic vDiagnostic2) {
                if (vDiagnostic1.getHighestSeverity() > vDiagnostic2.getHighestSeverity()) {
                    return 1;
                }
                if (vDiagnostic1.getHighestSeverity() == vDiagnostic2.getHighestSeverity()) {
                    return 0;
                }
                return -1;
            }
        });
        this.validationRegistry = validationRegistry;
        this.validationProviders = validationProviders;
    }

    @Override
    public VDiagnostic getDefaultValue() {
        return VViewFactory.eINSTANCE.createDiagnostic();
    }

    public void validate(EObject eObject) {
        if (this.validationRunning) {
            this.validationQueue.offer(eObject);
        } else {
            this.validationRunning = true;
            this.validateAndNotifyControls(eObject);
            EObject toValidate = this.validationQueue.poll();
            while (toValidate != null) {
                this.validateAndNotifyControls(toValidate);
                toValidate = this.validationQueue.poll();
            }
            this.validationRunning = false;
        }
    }

    private void validateAndNotifyControls(EObject eObject) {
        Diagnostic diagnostic = this.getDiagnosticForEObject(eObject);
        if (diagnostic.getSeverity() == 0) {
            this.handleOKDiagnostic(eObject, diagnostic);
        } else {
            Map<EStructuralFeature.Setting, Set<Diagnostic>> featureToValidationResult = this.collectChangedSettings(eObject, diagnostic);
            LinkedHashSet<UpdateTriple> updateTriplets = new LinkedHashSet<UpdateTriple>();
            for (EStructuralFeature.Setting invalidSetting : featureToValidationResult.keySet()) {
                for (VControl control : this.validationRegistry.getRenderablesForEObject(invalidSetting)) {
                    VDomainModelReference modelReference = control.getDomainModelReference();
                    Iterator settings = modelReference.getIterator();
                    VDiagnostic vDiagnostic = VViewFactory.eINSTANCE.createDiagnostic();
                    while (settings.hasNext()) {
                        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
                        if (!setting.getEObject().equals(invalidSetting.getEObject()) || !setting.getEStructuralFeature().equals(invalidSetting.getEStructuralFeature())) continue;
                        vDiagnostic.getDiagnostics().addAll((Collection)featureToValidationResult.get(invalidSetting));
                        updateTriplets.add(new UpdateTriple(control, setting, vDiagnostic));
                    }
                }
            }
            for (UpdateTriple triple : updateTriplets) {
                this.update((VElement)triple.control, triple.setting.getEObject(), triple.setting.getEStructuralFeature(), triple.diagnostic);
            }
        }
    }

    private Map<EStructuralFeature.Setting, Set<Diagnostic>> collectChangedSettings(EObject eObject, Diagnostic diagnostic) {
        LinkedHashMap<EStructuralFeature.Setting, Set<Diagnostic>> featureToValidationResult = new LinkedHashMap<EStructuralFeature.Setting, Set<Diagnostic>>();
        LinkedHashSet<EStructuralFeature> validatedFeatures = new LinkedHashSet<EStructuralFeature>();
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            if (childDiagnostic.getData().size() != 2) continue;
            EStructuralFeature feature = (EStructuralFeature)childDiagnostic.getData().get(1);
            validatedFeatures.add(feature);
            InternalEObject eObject2 = (InternalEObject)childDiagnostic.getData().get(0);
            EStructuralFeature.Setting setting = eObject2.eSetting(feature);
            if (!featureToValidationResult.containsKey(setting)) {
                featureToValidationResult.put(setting, new LinkedHashSet());
            }
            ((Set)featureToValidationResult.get(setting)).add(childDiagnostic);
        }
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            if (validatedFeatures.contains(feature)) continue;
            InternalEObject eObject2 = (InternalEObject)eObject;
            EStructuralFeature.Setting setting = eObject2.eSetting(feature);
            if (!featureToValidationResult.containsKey(setting)) {
                featureToValidationResult.put(setting, new LinkedHashSet());
            }
            ((Set)featureToValidationResult.get(setting)).add(Diagnostic.OK_INSTANCE);
        }
        return featureToValidationResult;
    }

    private void handleOKDiagnostic(EObject eObject, Diagnostic diagnostic) {
        LinkedHashSet<EObject> okEObjects = new LinkedHashSet<EObject>();
        okEObjects.add(eObject);
        if (diagnostic.getChildren() != null) {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                okEObjects.add((EObject)childDiagnostic.getData().get(0));
            }
        }
        for (EObject okEObject : okEObjects) {
            for (EStructuralFeature esf : okEObject.eClass().getEAllStructuralFeatures()) {
                EStructuralFeature.Setting diagSetting = ((InternalEObject)okEObject).eSetting(esf);
                for (VControl control : this.validationRegistry.getRenderablesForEObject(diagSetting)) {
                    if (VDiagnosticHelper.isEqual(control.getDiagnostic(), this.getDefaultValue())) continue;
                    VDomainModelReference modelReference = control.getDomainModelReference();
                    Iterator settings = modelReference.getIterator();
                    while (settings.hasNext()) {
                        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
                        if (!setting.getEStructuralFeature().getEContainingClass().isInstance((Object)okEObject)) continue;
                        this.update((VElement)control, okEObject, setting.getEStructuralFeature(), this.getDefaultValue());
                    }
                }
            }
        }
    }

    public void validate(Collection<EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.validate(eObject);
        }
    }

    @Deprecated
    public void validateSettings(Collection<UniqueSetting> eObjects) {
        for (UniqueSetting eObject : eObjects) {
            this.validate(eObject.getEObject());
        }
    }

    @Override
    protected void updateRenderable(VElement renderable) {
        VDiagnostic val = this.getValue(renderable);
        if (!VDiagnosticHelper.isEqual(renderable.getDiagnostic(), val)) {
            renderable.setDiagnostic((VDiagnostic)EcoreUtil.copy((EObject)val));
        }
    }

    public Diagnostic getDiagnosticForEObject(EObject object) {
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(object.eClass().getEPackage());
        BasicDiagnostic diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(object);
        if (validator == null) {
            validator = new EObjectValidator();
        }
        LinkedHashMap<Class, Object> context = new LinkedHashMap<Class, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, Diagnostician.INSTANCE);
        context.put(EValidator.class, validator);
        validator.validate(object, (DiagnosticChain)diagnostics, context);
        LinkedHashMap<EStructuralFeature, DiagnosticChain> diagnosticMap = new LinkedHashMap<EStructuralFeature, DiagnosticChain>();
        for (Diagnostic child : diagnostics.getChildren()) {
            if (!DiagnosticChain.class.isInstance(child)) continue;
            diagnosticMap.put((EStructuralFeature)child.getData().get(1), (DiagnosticChain)child);
        }
        for (ValidationProvider validationProvider : this.validationProviders) {
            List<Diagnostic> additionValidation = validationProvider.validate(object);
            for (Diagnostic additionDiagnostic : additionValidation) {
                if (diagnosticMap.containsKey(additionDiagnostic.getData().get(1))) {
                    ((DiagnosticChain)diagnosticMap.get(additionDiagnostic.getData().get(1))).add(additionDiagnostic);
                    continue;
                }
                diagnostics.add(additionDiagnostic);
            }
        }
        return diagnostics;
    }

    private class UpdateTriple {
        private final VControl control;
        private final EStructuralFeature.Setting setting;
        private final VDiagnostic diagnostic;

        public UpdateTriple(VControl control, EStructuralFeature.Setting setting, VDiagnostic diagnostic) {
            this.control = control;
            this.setting = setting;
            this.diagnostic = diagnostic;
        }
    }
}

