/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.handler;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.internal.ui.e3.Activator;
import org.eclipse.emf.ecp.internal.ui.PreferenceHelper;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerFactory;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportProjectHandler
extends AbstractHandler {
    private static final String FILE_EXTENSION = ExportImportDataUnits.ProjectSpace.getExtension();
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*" + FILE_EXTENSION + ")"};
    public static final String[] FILTER_EXTS = new String[]{"*" + FILE_EXTENSION};
    private static final String EXPORT_MODEL_PATH = "org.eclipse.emf.ecp.exportProjectModelPath";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        InternalProject project = (InternalProject)((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        ESLocalProject localProject = EMFStoreProvider.INSTANCE.getProjectSpace(project);
        String filePath = this.getFilePathByFileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), project.getName());
        if (filePath == null) {
            return null;
        }
        try {
            new ExportImportControllerExecutor(new File(filePath), (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Export.getExportProjectSpaceController((ProjectSpace)((ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI())));
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
        return null;
    }

    private String getFilePathByFileDialog(Shell shell, String modelElementName) {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference((String)EXPORT_MODEL_PATH, (String)System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        dialog.setOverwrite(true);
        try {
            String initialFileName = "Project_" + modelElementName + FILE_EXTENSION;
            dialog.setFileName(initialFileName);
        }
        catch (NullPointerException nullPointerException) {}
        String filePath = dialog.open();
        PreferenceHelper.setPreference((String)EXPORT_MODEL_PATH, (String)new File(filePath).getParent());
        return filePath;
    }
}

