/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.editor.view;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.ide.editor.view.Activator;
import org.eclipse.emf.ecp.ide.view.service.ViewModelEditorCallback;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class ViewEditorPart
extends EditorPart
implements ViewModelEditorCallback {
    private Resource resource;
    private BasicCommandStack basicCommandStack;
    private Composite parent;
    private ECPSWTView render;

    public void doSave(IProgressMonitor monitor) {
        try {
            this.resource.save(null);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
        this.basicCommandStack = new BasicCommandStack();
    }

    private ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)this.basicCommandStack, (ResourceSet)resourceSet);
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        return resourceSet;
    }

    public boolean isDirty() {
        return this.basicCommandStack.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.loadAndShowView();
        VView view = (VView)this.resource.getContents().get(0);
        Activator.getViewModelRegistry().registerViewModelEditor(view, (ViewModelEditorCallback)this);
        if (view.getRootEClass() != null) {
            Activator.getViewModelRegistry().register(view.getRootEClass().eResource().getURI().toString(), view);
        }
    }

    private void loadAndShowView() {
        try {
            FileEditorInput fei = (FileEditorInput)this.getEditorInput();
            ResourceSet resourceSet = this.createResourceSet();
            this.resource = resourceSet.getResource(URI.createURI((String)fei.getURI().toURL().toExternalForm()), true);
            this.resource.load(null);
            VView view = (VView)this.resource.getContents().get(0);
            this.render = ECPSWTViewRenderer.INSTANCE.render(this.parent, (EObject)view);
        }
        catch (ECPRendererException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.ide.editor.view", e.getMessage(), (Throwable)e));
        }
    }

    public void setFocus() {
    }

    public void reloadViewModel() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ViewEditorPart.this.render != null) {
                    ViewEditorPart.this.render.dispose();
                    ViewEditorPart.this.render.getSWTControl().dispose();
                }
                ViewEditorPart.this.loadAndShowView();
            }
        });
    }

    public void dispose() {
        VView view = (VView)this.resource.getContents().get(0);
        Activator.getViewModelRegistry().unregisterViewModelEditor(view, (ViewModelEditorCallback)this);
        super.dispose();
    }
}

