/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.model;

import java.util.Collection;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectContentTouchedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectOpenClosedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectsChangedObserver;
import org.eclipse.emf.ecp.internal.ui.model.ECPContentProvider;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelContentProvider
extends ECPContentProvider<ECPProjectManager>
implements ECPProjectsChangedObserver,
ECPProjectOpenClosedObserver,
ECPProjectContentTouchedObserver {
    public void projectsChanged(Collection<ECPProject> oldProjects, Collection<ECPProject> newProjects) {
        this.refreshViewer();
    }

    public void projectChanged(ECPProject project, boolean opened) {
        this.refreshViewer(true, project);
    }

    public void contentTouched(ECPProject project, Collection<Object> objects, boolean structural) {
        this.refreshViewer(structural, objects.toArray());
        if (!objects.contains(project)) {
            this.refreshViewer(false, project);
        }
    }

    @Override
    protected void connectInput(ECPProjectManager input) {
        ECPUtil.getECPObserverBus().register((ECPObserver)this);
    }

    @Override
    protected void disconnectInput(ECPProjectManager input) {
        ECPUtil.getECPObserverBus().unregister((ECPObserver)this);
    }

    @Override
    protected void fillChildren(Object parent, InternalChildrenList childrenList) {
        if (parent == ECPUtil.getECPProjectManager()) {
            childrenList.addChildren(ECPUtil.getECPProjectManager().getProjects());
        } else {
            super.fillChildren(parent, childrenList);
        }
    }
}

