/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.PreferenceHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ECPExportHandlerHelper {
    private static final String UNEXPECTED_ERROR_MESSAGE = "An unexpected error in a ECP plugin occured.";
    private static final String FILE_EXTENSION = "xmi";
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*.xmi)"};
    public static final String[] FILTER_EXTS = new String[]{"*.xmi"};
    private static final String EXPORT_MODEL_PATH = "org.eclipse.emf.emfstore.client.ui.exportModelPath";

    private ECPExportHandlerHelper() {
    }

    public static void export(Shell shell, List<EObject> eObjects) {
        if (eObjects.size() > 0) {
            String filePath = ECPExportHandlerHelper.getFilePathByFileDialog(shell, ECPExportHandlerHelper.getNameForModelElement(eObjects.get(0)));
            if (filePath == null) {
                return;
            }
            PreferenceHelper.setPreference(EXPORT_MODEL_PATH, new File(filePath).getParent());
            ECPExportHandlerHelper.runCommand(eObjects, filePath, shell);
        }
    }

    private static String getNameForModelElement(EObject modelElement) {
        ComposedAdapterFactory adapterFactory = null;
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        String text = labelProvider.getText((Object)modelElement);
        adapterFactory.dispose();
        labelProvider.dispose();
        return text;
    }

    private static void runCommand(List<EObject> exportModelElements, String filePath, Shell shell) {
        File file = new File(filePath);
        URI uri = URI.createFileURI((String)filePath);
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        progressDialog.open();
        progressDialog.getProgressMonitor().beginTask("Export modelelement...", 100);
        progressDialog.getProgressMonitor().worked(10);
        try {
            ECPExportHandlerHelper.saveEObjectToResource(exportModelElements, uri);
        }
        catch (IOException e) {
            ECPExportHandlerHelper.showExceptionDialog(e.getMessage(), e, shell);
        }
        progressDialog.getProgressMonitor().done();
        progressDialog.close();
        MessageDialog.openInformation(null, (String)"Export", (String)("Exported modelelement to file " + file.getName()));
    }

    private static void showExceptionDialog(String message, Exception cause, Shell shell) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(message);
        String title = "Error";
        if (cause != null) {
            stringBuilder.append(": ");
            stringBuilder.append(cause.getMessage());
            title = cause.getClass().getName();
        }
        String string = stringBuilder.toString();
        MessageDialog.openError((Shell)shell, (String)title, (String)string);
        Activator.log(UNEXPECTED_ERROR_MESSAGE, cause);
    }

    private static String getFilePathByFileDialog(Shell shell, String modelElementName) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference(EXPORT_MODEL_PATH, System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        dialog.setOverwrite(true);
        try {
            String initialFileName = "ModelElement_" + modelElementName + "." + FILE_EXTENSION;
            dialog.setFileName(initialFileName);
        }
        catch (NullPointerException nullPointerException) {}
        String filePath = dialog.open();
        return filePath;
    }

    private static void saveEObjectToResource(List<? extends EObject> eObjects, URI resourceURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(resourceURI);
        EList contents = resource.getContents();
        for (EObject eObject : eObjects) {
            contents.add((Object)eObject);
        }
        contents.addAll(eObjects);
        resource.save(null);
    }
}

