/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.view.emf;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecp.internal.ui.view.emf.ExtendedColorRegistry;
import org.eclipse.emf.ecp.internal.ui.view.emf.ExtendedFontRegistry;
import org.eclipse.emf.ecp.internal.ui.view.emf.ExtendedImageRegistry;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class AdapterFactoryLabelProvider
implements ILabelProvider,
ITableLabelProvider,
INotifyChangedListener {
    protected AdapterFactory adapterFactory;
    protected Font defaultFont;
    protected Color defaultForeground;
    protected Color defaultBackground;
    protected Collection<ILabelProviderListener> labelProviderListeners;
    protected boolean isFireLabelUpdateNotifications = true;
    private static final Class<?> IItemLabelProviderClass = IItemLabelProvider.class;
    private static final Class<?> ITableItemLabelProviderClass = ITableItemLabelProvider.class;
    private static final Class<?> IItemFontProviderClass = IItemFontProvider.class;
    private static final Class<?> IItemColorProviderClass = IItemColorProvider.class;
    private static final Class<?> ITableItemFontProviderClass = ITableItemFontProvider.class;
    private static final Class<?> ITableItemColorProviderClass = ITableItemColorProvider.class;

    public AdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.labelProviderListeners = new ArrayList<ILabelProviderListener>();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.adapterFactory = adapterFactory;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public void setDefaultForeground(Color color) {
        this.defaultForeground = color;
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public void setDefaultBackground(Color color) {
        this.defaultBackground = color;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProviderListeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProviderListeners.remove(listener);
    }

    public void dispose() {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
    }

    public boolean isLabelProperty(Object object, String id) {
        return true;
    }

    public Image getImage(Object object) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
        return itemLabelProvider != null ? this.getImageFromObject(itemLabelProvider.getImage(object)) : this.getDefaultImage(object);
    }

    protected Image getDefaultImage(Object object) {
        String image = "full/obj16/GenericValue";
        if (object instanceof String) {
            image = "full/obj16/TextValue";
        } else if (object instanceof Boolean) {
            image = "full/obj16/BooleanValue";
        } else if (object instanceof Float || object instanceof Double) {
            image = "full/obj16/RealValue";
        } else if (object instanceof Integer || object instanceof Short || object instanceof Long || object instanceof Byte) {
            image = "full/obj16/RealValue";
        }
        return this.getImageFromObject(EMFEditPlugin.INSTANCE.getImage(image));
    }

    protected Image getImageFromObject(Object object) {
        return ExtendedImageRegistry.INSTANCE.getImage(object);
    }

    public String getText(Object object) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
        return itemLabelProvider != null ? itemLabelProvider.getText(object) : (object == null ? "" : object.toString());
    }

    public Font getFont(Object object) {
        IItemFontProvider itemFontProvider = (IItemFontProvider)this.adapterFactory.adapt(object, IItemFontProviderClass);
        return itemFontProvider != null ? this.getFontFromObject(itemFontProvider.getFont(object)) : null;
    }

    protected Font getFontFromObject(Object object) {
        return object == null ? null : ExtendedFontRegistry.INSTANCE.getFont(this.defaultFont, object);
    }

    public Color getForeground(Object object) {
        IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
        return itemColorProvider != null ? this.getColorFromObject(itemColorProvider.getForeground(object)) : null;
    }

    public Color getBackground(Object object) {
        IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
        return itemColorProvider != null ? this.getColorFromObject(itemColorProvider.getBackground(object)) : null;
    }

    protected Color getColorFromObject(Object object) {
        return object == null ? null : ExtendedColorRegistry.INSTANCE.getColor(this.defaultForeground, this.defaultBackground, object);
    }

    public Image getColumnImage(Object object, int columnIndex) {
        ITableItemLabelProvider tableItemLabelProvider = (ITableItemLabelProvider)this.adapterFactory.adapt(object, ITableItemLabelProviderClass);
        Image result = null;
        if (tableItemLabelProvider != null) {
            result = this.getImageFromObject(tableItemLabelProvider.getColumnImage(object, columnIndex));
        } else {
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
            if (itemLabelProvider != null) {
                result = this.getImageFromObject(itemLabelProvider.getImage(object));
            }
        }
        return result;
    }

    public String getColumnText(Object object, int columnIndex) {
        ITableItemLabelProvider tableItemLabelProvider = (ITableItemLabelProvider)this.adapterFactory.adapt(object, ITableItemLabelProviderClass);
        if (tableItemLabelProvider != null) {
            return tableItemLabelProvider.getColumnText(object, columnIndex);
        }
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText(object);
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public Font getFont(Object object, int columnIndex) {
        ITableItemFontProvider tableItemFontProvider = (ITableItemFontProvider)this.adapterFactory.adapt(object, ITableItemFontProviderClass);
        Font result = null;
        if (tableItemFontProvider != null) {
            result = this.getFontFromObject(tableItemFontProvider.getFont(object, columnIndex));
        } else {
            IItemFontProvider itemFontProvider = (IItemFontProvider)this.adapterFactory.adapt(object, IItemFontProviderClass);
            if (itemFontProvider != null) {
                result = this.getFontFromObject(itemFontProvider.getFont(object));
            }
        }
        return result;
    }

    public Color getForeground(Object object, int columnIndex) {
        ITableItemColorProvider tableItemColorProvider = (ITableItemColorProvider)this.adapterFactory.adapt(object, ITableItemColorProviderClass);
        Color result = null;
        if (tableItemColorProvider != null) {
            result = this.getColorFromObject(tableItemColorProvider.getForeground(object, columnIndex));
        } else {
            IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
            if (itemColorProvider != null) {
                result = this.getColorFromObject(itemColorProvider.getForeground(object));
            }
        }
        return result;
    }

    public Color getBackground(Object object, int columnIndex) {
        ITableItemColorProvider tableItemColorProvider = (ITableItemColorProvider)this.adapterFactory.adapt(object, ITableItemColorProviderClass);
        Color result = null;
        if (tableItemColorProvider != null) {
            result = this.getColorFromObject(tableItemColorProvider.getBackground(object, columnIndex));
        } else {
            IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
            if (itemColorProvider != null) {
                result = this.getColorFromObject(itemColorProvider.getBackground(object));
            }
        }
        return result;
    }

    public boolean isFireLabelUpdateNotifications() {
        return this.isFireLabelUpdateNotifications;
    }

    public void setFireLabelUpdateNotifications(boolean isFireLabelUpdateNotifications) {
        this.isFireLabelUpdateNotifications = isFireLabelUpdateNotifications;
    }

    public void fireLabelProviderChanged() {
        for (ILabelProviderListener labelProviderListener : this.labelProviderListeners) {
            labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.isFireLabelUpdateNotifications() && (!(notification instanceof IViewerNotification) || ((IViewerNotification)notification).isLabelUpdate())) {
            for (ILabelProviderListener labelProviderListener : this.labelProviderListeners) {
                labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, notification.getNotifier()));
            }
        }
    }

    public static class ColorProvider
    extends AdapterFactoryLabelProvider
    implements IColorProvider,
    ITableColorProvider {
        public ColorProvider(AdapterFactory adapterFactory, Color defaultForeground, Color defaultBackground) {
            super(adapterFactory);
            this.setDefaultForeground(defaultForeground);
            this.setDefaultBackground(defaultBackground);
        }

        public ColorProvider(AdapterFactory adapterFactory, Viewer viewer) {
            this(adapterFactory, viewer.getControl().getForeground(), viewer.getControl().getBackground());
        }
    }

    public static class FontAndColorProvider
    extends AdapterFactoryLabelProvider
    implements IColorProvider,
    IFontProvider,
    ITableColorProvider,
    ITableFontProvider {
        public FontAndColorProvider(AdapterFactory adapterFactory, Font defaultFont, Color defaultForeground, Color defaultBackground) {
            super(adapterFactory);
            this.setDefaultFont(defaultFont);
            this.setDefaultForeground(defaultForeground);
            this.setDefaultBackground(defaultBackground);
        }

        public FontAndColorProvider(AdapterFactory adapterFactory, Viewer viewer) {
            this(adapterFactory, viewer.getControl().getFont(), viewer.getControl().getForeground(), viewer.getControl().getBackground());
        }
    }

    public static class FontProvider
    extends AdapterFactoryLabelProvider
    implements IFontProvider,
    ITableFontProvider {
        public FontProvider(AdapterFactory adapterFactory, Font defaultFont) {
            super(adapterFactory);
            this.setDefaultFont(defaultFont);
        }

        public FontProvider(AdapterFactory adapterFactory, Viewer viewer) {
            this(adapterFactory, viewer.getControl().getFont());
        }
    }
}

