/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SWTRendererFactory {
    public static final SWTRendererFactory INSTANCE = new SWTRendererFactory();
    private static final String RENDER_EXTENSION = "org.eclipse.emf.ecp.ui.view.swt.renderers";
    private final Map<Class<? extends VElement>, AbstractSWTRenderer<VElement>> rendererMapping = new LinkedHashMap<Class<? extends VElement>, AbstractSWTRenderer<VElement>>();

    private SWTRendererFactory() {
        this.readRenderer();
    }

    private void readRenderer() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    AbstractSWTRenderer renderer = (AbstractSWTRenderer)configurationElement.createExecutableExtension("renderer");
                    String clazz = configurationElement.getAttribute("element");
                    Class renderable = SWTRendererFactory.loadClass(extension.getContributor().getName(), clazz);
                    this.rendererMapping.put(renderable, renderer);
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    public List<RenderingResultRow<Control>> render(Composite parent, VElement vElement, ViewModelContext viewContext) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        AbstractSWTRenderer<VElement> renderer = this.rendererMapping.get(vElement.getClass().getInterfaces()[0]);
        if (renderer == null) {
            throw new NoRendererFoundException(vElement);
        }
        return renderer.render(parent, vElement, viewContext);
    }
}

