/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.internal.ui.Activator;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewProviderHelper {
    private static final String CLASS_CANNOT_BE_RESOLVED = "%1$s cannot be loaded because bundle %2$s cannot be resolved.";
    private static final String CLASS = "class";
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.ecp.ui.view.viewModelProviders";
    private static Set<IViewProvider> viewProviders = new HashSet<IViewProvider>();

    private ViewProviderHelper() {
    }

    private static Set<IViewProvider> getViewProviders() {
        if (viewProviders == null || viewProviders.isEmpty()) {
            ViewProviderHelper.readViewProviders();
        }
        return viewProviders;
    }

    private static void readViewProviders() {
        IConfigurationElement[] controls;
        IConfigurationElement[] iConfigurationElementArray = controls = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String clazz = e.getAttribute(CLASS);
                Class resolvedClass = ViewProviderHelper.loadClass(e.getContributor().getName(), clazz);
                Constructor controlConstructor = resolvedClass.getConstructor(new Class[0]);
                IViewProvider viewProvider = (IViewProvider)controlConstructor.newInstance(new Object[0]);
                viewProviders.add(viewProvider);
            }
            catch (ClassNotFoundException ex) {
                Activator.log(ex);
            }
            catch (NoSuchMethodException ex) {
                Activator.log(ex);
            }
            catch (SecurityException ex) {
                Activator.log(ex);
            }
            catch (InstantiationException ex) {
                Activator.log(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.log(ex);
            }
            catch (IllegalArgumentException ex) {
                Activator.log(ex);
            }
            catch (InvocationTargetException ex) {
                Activator.log(ex);
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.format(CLASS_CANNOT_BE_RESOLVED, clazz, bundleName));
        }
        return bundle.loadClass(clazz);
    }

    public static VView getView(EObject eObject) {
        int highestPrio = -1;
        IViewProvider selectedProvider = null;
        for (IViewProvider viewProvider : ViewProviderHelper.getViewProviders()) {
            int prio = viewProvider.canRender(eObject);
            if (prio <= highestPrio) continue;
            highestPrio = prio;
            selectedProvider = viewProvider;
        }
        if (selectedProvider != null) {
            return selectedProvider.generate(eObject);
        }
        return null;
    }
}

