/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPControlSWT;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTRenderingHelper;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTControlRenderer
extends AbstractSWTRenderer<VControl> {
    public static final SWTControlRenderer INSTANCE = new SWTControlRenderer();

    public List<RenderingResultRow<Control>> render(Composite parent, VControl vControl, ViewModelContext viewContext) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        return this.renderModel(parent, vControl, viewContext);
    }

    protected List<RenderingResultRow<Control>> renderModel(Composite parent, final VControl vControl, final ViewModelContext viewContext) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        ECPControlFactory controlFactory = Activator.getDefault().getECPControlFactory();
        if (controlFactory == null) {
            Activator.getDefault().ungetECPControlFactory();
            return null;
        }
        ECPAbstractControl control = (ECPAbstractControl)controlFactory.createControl(ECPAbstractControl.class, vControl.getDomainModelReference());
        if (control != null) {
            List createControls;
            EStructuralFeature.Setting setting;
            control.init(viewContext, vControl);
            Label label = null;
            if (vControl.getLabelAlignment() == LabelAlignment.LEFT && (setting = control.getFirstSetting()) != null) {
                String labelText;
                IItemPropertyDescriptor itemPropertyDescriptor = control.getItemPropertyDescriptor(setting);
                if (itemPropertyDescriptor == null) {
                    throw new NoPropertyDescriptorFoundExeption(setting.getEObject(), setting.getEStructuralFeature());
                }
                label = new Label(parent, 0);
                label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
                label.setBackground(parent.getBackground());
                String extra = "";
                if (setting.getEStructuralFeature().getLowerBound() > 0) {
                    extra = "*";
                }
                if ((labelText = itemPropertyDescriptor.getDisplayName((Object)setting.getEObject())) != null && labelText.trim().length() != 0) {
                    label.setText(String.valueOf(labelText) + extra);
                    label.setToolTipText(itemPropertyDescriptor.getDescription((Object)setting.getEObject()));
                }
            }
            if ((createControls = ((ECPControlSWT)control).createControls(parent)) == null) {
                return null;
            }
            control.setEditable(!vControl.isReadonly());
            if (!vControl.isReadonly()) {
                control.setEditable(vControl.isEnabled());
            }
            final ArrayList<RenderingResultRow<Control>> result = new ArrayList<RenderingResultRow<Control>>();
            if (label != null) {
                Set mainControls = ((RenderingResultRow)createControls.get(0)).getControls();
                Object[] controls = new Control[mainControls.size() + 1];
                controls[0] = label;
                int i = 1;
                for (Control mainControl : mainControls) {
                    controls[i++] = mainControl;
                }
                result.add((RenderingResultRow<Control>)SWTRenderingHelper.INSTANCE.getResultRowFactory().createRenderingResultRow(controls));
            } else {
                result.addAll(createControls);
            }
            final ViewModelContext.ModelChangeListener listener = new ViewModelContext.ModelChangeListener(){

                public void notifyRemove(Notifier notifier) {
                }

                public void notifyChange(ModelChangeNotification notification) {
                    if (notification.getNotifier() != vControl) {
                        return;
                    }
                    if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Visible()) {
                        SWTControlRenderer.applyVisible((VElement)((VElement)vControl), (List)result);
                    }
                }

                public void notifyAdd(Notifier notifier) {
                }
            };
            viewContext.registerViewChangeListener(listener);
            parent.addDisposeListener(new DisposeListener(){
                private static final long serialVersionUID = 1L;

                public void widgetDisposed(DisposeEvent e) {
                    viewContext.unregisterViewChangeListener(listener);
                }
            });
            SWTControlRenderer.applyVisible((VElement)vControl, result);
            return result;
        }
        Activator.getDefault().ungetECPControlFactory();
        return null;
    }
}

