/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.groupedgrid.swt;

import java.util.List;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VGroup;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VGroupedGrid;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VRow;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VSpan;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedGridSWTRenderer
extends AbstractSWTRenderer<VGroupedGrid> {
    public static final GroupedGridSWTRenderer INSTANCE = new GroupedGridSWTRenderer();

    protected List<RenderingResultRow<Control>> renderModel(Composite parent, VGroupedGrid groupedGrid, ViewModelContext viewContext) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        int maxNumColumns = this.calculateColumns(groupedGrid);
        GridLayoutFactory.fillDefaults().numColumns(maxNumColumns).equalWidth(true).applyTo(columnComposite);
        for (VGroup group : groupedGrid.getGroups()) {
            Composite labelComposite = new Composite(columnComposite, 0);
            labelComposite.setBackground(parent.getBackground());
            GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(labelComposite);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 1).span(maxNumColumns, 1).applyTo((Control)labelComposite);
            Label l = new Label(labelComposite, 0);
            l.setText(group.getName());
            l.setBackground(parent.getBackground());
            GridDataFactory.fillDefaults().grab(false, false).align(1, 1).applyTo((Control)l);
            Label seperator = new Label(labelComposite, 258);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)seperator);
            for (VRow row : group.getRows()) {
                int spanned = 0;
                for (VContainedElement child : row.getChildren()) {
                    VControl control;
                    int hSpan = this.getHSpanOfComposite(child);
                    List resultRows = SWTRendererFactory.INSTANCE.render(columnComposite, (VElement)child, viewContext);
                    if (resultRows == null) continue;
                    Control childRender = (Control)((RenderingResultRow)resultRows.get(0)).getMainControl();
                    childRender.setBackground(parent.getBackground());
                    GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(0, 0).span(hSpan, 1).applyTo(childRender);
                    GridDataFactory.createFrom((GridData)((GridData)childRender.getLayoutData())).indent(10, 0).applyTo(childRender);
                    spanned += hSpan;
                    if (!VControl.class.isInstance(child) || (control = (VControl)child).getLabelAlignment() != LabelAlignment.LEFT) continue;
                    ++spanned;
                }
                int spanDif = maxNumColumns - spanned;
                if (spanDif == 0) continue;
                Label filler = new Label(columnComposite, 0);
                filler.setBackground(parent.getBackground());
                GridDataFactory.fillDefaults().span(spanDif, 1).applyTo((Control)filler);
            }
        }
        return this.createResult(new Control[]{columnComposite});
    }

    private int calculateColumns(VGroupedGrid renderable) {
        int maxColumns = 0;
        for (VGroup group : renderable.getGroups()) {
            for (VRow row : group.getRows()) {
                int columns = 0;
                for (VContainedElement composite : row.getChildren()) {
                    columns += this.getHSpanOfComposite(composite) + this.getExtraColumnForLabel(composite);
                }
                if (columns <= maxColumns) continue;
                maxColumns = columns;
            }
        }
        return maxColumns;
    }

    private int getHSpanOfComposite(VContainedElement composite) {
        for (VAttachment attachment : composite.getAttachments()) {
            if (!VSpan.class.isInstance(attachment)) continue;
            VSpan span = (VSpan)attachment;
            return span.getHorizontalSpan();
        }
        return 1;
    }

    private int getExtraColumnForLabel(VContainedElement child) {
        if (VControl.class.isInstance(child)) {
            VControl control = (VControl)child;
            return control.getLabelAlignment() == LabelAlignment.LEFT ? 1 : 0;
        }
        return 0;
    }
}

