/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.wizards;

import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.wizards.page.AddRepositoryPage;
import org.eclipse.emf.ecp.internal.wizards.page.SelectOrCreateRepositoryPage;
import org.eclipse.emf.ecp.internal.wizards.page.SelectRepositoryPage;
import org.eclipse.emf.ecp.ui.common.AddRepositoryComposite;
import org.eclipse.emf.ecp.ui.common.CompositeFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ShareWizard
extends Wizard {
    private ECPRepository selectedRepository;
    private ECPProvider provider;
    private AddRepositoryComposite repositoryComposite;
    private boolean useExistingRepository = true;

    public ECPProvider getProvider() {
        return this.provider;
    }

    public ECPRepository getSelectedRepository() {
        return this.selectedRepository;
    }

    public void setSelectedRepository(ECPRepository selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

    public void setUseExistingRepository(boolean useExistingRepository) {
        this.useExistingRepository = useExistingRepository;
    }

    public void addPages() {
        SelectOrCreateRepositoryPage userChoicePage = new SelectOrCreateRepositoryPage("UserChoice");
        SelectRepositoryPage selectPage = new SelectRepositoryPage("SelectRepository");
        this.repositoryComposite = CompositeFactory.getAddRepositoryComposite(this.provider);
        AddRepositoryPage addPage = new AddRepositoryPage("AddRepository", this.repositoryComposite);
        this.addPage((IWizardPage)userChoicePage);
        this.addPage((IWizardPage)selectPage);
        this.addPage((IWizardPage)addPage);
    }

    public boolean canFinish() {
        if (this.useExistingRepository) {
            return this.selectedRepository != null;
        }
        return this.repositoryComposite.getProperties() != null && this.repositoryComposite.getProperties().hasProperties() && this.repositoryComposite.getRepositoryName() != null && this.repositoryComposite.getRepositoryName().length() != 0;
    }

    public boolean performFinish() {
        if (this.selectedRepository == null) {
            this.selectedRepository = ECPUtil.getECPRepositoryManager().addRepository(this.provider, this.repositoryComposite.getRepositoryName(), this.repositoryComposite.getRepositoryLabel() == null ? "" : this.repositoryComposite.getRepositoryLabel(), this.repositoryComposite.getRepositoryDescription() == null ? "" : this.repositoryComposite.getRepositoryDescription(), this.repositoryComposite.getProperties());
        }
        return true;
    }

    public void init(ECPProvider provider) {
        this.provider = provider;
        this.setWindowTitle(Messages.ShareWizard_Title_Share);
    }
}

