/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.util.ECPHandlerHelper;
import org.eclipse.emf.ecp.internal.wizards.SelectModelElementWizard;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.ui.common.CompositeFactory;
import org.eclipse.emf.ecp.ui.common.SelectionComposite;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ECPReferenceServiceImpl
implements ReferenceService {
    private ViewModelContext context;
    private ECPProject ecpProject;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.ecpProject = ECPUtil.getECPProjectManager().getProject((Object)context.getDomainModel());
    }

    public void dispose() {
        this.ecpProject = null;
        this.context = null;
    }

    public int getPriority() {
        return 0;
    }

    public void addModelElement(EObject eObject, EReference eReference) {
        if (eReference == null) {
            this.ecpProject.getContents().add((Object)eObject);
        }
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Operation not permitted for container references!");
            return;
        }
        ECPControlHelper.addModelElementInReference((EObject)this.context.getDomainModel(), (EObject)eObject, (EReference)eReference, (EditingDomain)this.ecpProject.getEditingDomain());
    }

    public EObject getNewElementFor(EReference eReference) {
        Collection classes = ECPUtil.getSubClasses((EClass)eReference.getEReferenceType());
        SelectModelElementWizard wizard = new SelectModelElementWizard("New Reference Element", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.NewModelElementWizard_PageTitle_AddModelElement, Messages.NewModelElementWizard_PageDescription_AddModelElement);
        SelectionComposite<TreeViewer> helper = CompositeFactory.getSelectModelClassComposite(new HashSet<EPackage>(), new HashSet<EPackage>(), classes);
        wizard.setCompositeProvider(helper);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        EObject newMEInstance = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = helper.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            EClass eClasse = (EClass)selection[0];
            EPackage ePackage = eClasse.getEPackage();
            newMEInstance = ePackage.getEFactoryInstance().create(eClasse);
        }
        if (newMEInstance == null) {
            return null;
        }
        return newMEInstance;
    }

    public EObject getExistingElementFor(EReference eReference) {
        Iterator allElements = ((InternalProject)this.ecpProject).getReferenceCandidates(this.context.getDomainModel(), eReference);
        HashSet<EObject> elements = new HashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        SelectModelElementWizard wizard = new SelectModelElementWizard("Select Elements", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.ModelelementSelectionDialog_DialogTitle, Messages.ModelelementSelectionDialog_DialogMessage_SearchPattern, EObject.class);
        SelectionComposite<TableViewer> tableSelectionComposite = CompositeFactory.getTableSelectionComposite(elements.toArray());
        wizard.setCompositeProvider(tableSelectionComposite);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        EObject eObject = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = tableSelectionComposite.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            eObject = (EObject)selection[0];
        }
        return eObject;
    }

    public void openInNewContext(EObject eObject) {
        ECPHandlerHelper.openModelElement(eObject, this.ecpProject);
    }
}

