/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SelectAttributesDialog
extends Dialog {
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryLabelProvider labelProvider;
    private final VView view;
    private final Set<EStructuralFeature> selectedFeatures = new LinkedHashSet<EStructuralFeature>();
    private final EClass rootClass;

    public SelectAttributesDialog(VView view, EClass rootClass, Shell parentShell) {
        super(parentShell);
        this.view = view;
        this.rootClass = rootClass;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        final Button bUnreferenced = new Button(composite, 32);
        bUnreferenced.setText("Show only unreferenced Attributes?");
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)bUnreferenced);
        Label labelAttributes = new Label(composite, 0);
        labelAttributes.setText("Select Attributes");
        final CheckboxTableViewer tvAttributes = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        tvAttributes.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tvAttributes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(-1, 200).applyTo(tvAttributes.getControl());
        tvAttributes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EStructuralFeature object = (EStructuralFeature)event.getElement();
                if (event.getChecked()) {
                    SelectAttributesDialog.this.selectedFeatures.add(object);
                } else {
                    SelectAttributesDialog.this.selectedFeatures.remove(object);
                }
            }
        });
        Object attributes = null;
        attributes = !bUnreferenced.getSelection() ? this.rootClass.getEAllStructuralFeatures() : this.getUnreferencedSegmentAttributes(this.rootClass);
        tvAttributes.setInput(attributes);
        bUnreferenced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object attributes = null;
                attributes = !bUnreferenced.getSelection() ? SelectAttributesDialog.this.rootClass.getEAllStructuralFeatures() : SelectAttributesDialog.this.getUnreferencedSegmentAttributes(SelectAttributesDialog.this.rootClass);
                tvAttributes.setInput(attributes);
            }
        });
        Composite compositeButtons = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(compositeButtons);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)compositeButtons);
        Button bSelectAll = new Button(compositeButtons, 8);
        bSelectAll.setText("Select All");
        bSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)tvAttributes.getInput();
                tvAttributes.setAllChecked(true);
                SelectAttributesDialog.this.selectedFeatures.addAll(segments);
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bSelectAll);
        Button bDeSelectAll = new Button(compositeButtons, 8);
        bDeSelectAll.setText("Deselect All");
        bDeSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)tvAttributes.getInput();
                tvAttributes.setAllChecked(false);
                SelectAttributesDialog.this.selectedFeatures.removeAll(segments);
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bDeSelectAll);
        return composite;
    }

    public boolean close() {
        this.labelProvider.dispose();
        this.composedAdapterFactory.dispose();
        return super.close();
    }

    private List<EStructuralFeature> getUnreferencedSegmentAttributes(EClass eClass) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        ArrayList<EStructuralFeature> allStructuralFeatures = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        TreeIterator eAllContents = this.view.eAllContents();
        while (eAllContents.hasNext()) {
            VControl control;
            VDomainModelReference domainModelReference;
            EObject eObject = (EObject)eAllContents.next();
            if (!VControl.class.isInstance(eObject) || (domainModelReference = (control = (VControl)eObject).getDomainModelReference()) == null) continue;
            Iterator structuralFeatureIterator = domainModelReference.getEStructuralFeatureIterator();
            while (structuralFeatureIterator.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)structuralFeatureIterator.next();
                if (feature == null || !feature.getEContainingClass().equals(eClass)) continue;
                result.add(feature);
            }
        }
        allStructuralFeatures.removeAll(result);
        return allStructuralFeatures;
    }

    public Set<EStructuralFeature> getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public EClass getRootClass() {
        return this.rootClass;
    }
}

