/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.e4.view;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextProvider;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.model.ModelContentProvider;
import org.eclipse.emf.ecp.internal.ui.util.ECPHandlerHelper;
import org.eclipse.emf.ecp.ui.common.TreeViewerFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class ECPModelView {
    public static final String P_LINK_WITH_EDITOR = "linkWithEditor";
    private static final String POPUPMENU_NAVIGATOR = "org.eclipse.emf.ecp.e4.application.popupmenu.navigator";
    private TreeViewer modelExplorerTree;
    private ModelContentProvider contentProvider;
    @Inject
    private EPartService partService;
    private MPart modelViewPart;

    @PostConstruct
    public void create(Composite composite, EMenuService menuService, final ESelectionService selectionService, MPart part) {
        this.modelViewPart = part;
        if (this.modelViewPart.getPersistedState().containsKey(P_LINK_WITH_EDITOR)) {
            for (MToolBarElement toolbarElement : part.getToolbar().getChildren()) {
                if (!toolbarElement.getElementId().endsWith("link")) continue;
                ((MToolItem)toolbarElement).setSelected(Boolean.valueOf((String)this.modelViewPart.getPersistedState().get(P_LINK_WITH_EDITOR)).booleanValue());
            }
        }
        this.modelExplorerTree = TreeViewerFactory.createModelExplorerViewer((Composite)composite, (boolean)true, null);
        menuService.registerContextMenu((Object)this.modelExplorerTree.getTree(), POPUPMENU_NAVIGATOR);
        this.contentProvider = (ModelContentProvider)this.modelExplorerTree.getContentProvider();
        this.modelExplorerTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                    Object firstElement = structuredSelection.getFirstElement();
                    if (firstElement instanceof ECPProject) {
                        ECPProject project = (ECPProject)firstElement;
                        if (!project.isOpen()) {
                            project.open();
                        }
                    } else if (firstElement instanceof EObject) {
                        ECPContainer context = ECPUtil.getModelContext((ECPModelContextProvider)ECPModelView.this.contentProvider, (Object[])structuredSelection.toArray());
                        ECPHandlerHelper.openModelElement((Object)firstElement, (ECPProject)((ECPProject)context));
                    }
                }
            }
        });
        this.modelExplorerTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                ISelection selection = event.getSelection();
                if (IStructuredSelection.class.isInstance(selection) && (structuredSelection = (IStructuredSelection)selection) != null && !structuredSelection.isEmpty()) {
                    if (structuredSelection.size() == 1) {
                        selectionService.setSelection(structuredSelection.getFirstElement());
                        ECPModelView.this.activateCorrectPart(structuredSelection.getFirstElement());
                    } else {
                        selectionService.setSelection((Object)structuredSelection.toList());
                    }
                }
            }
        });
    }

    private void activateCorrectPart(Object firstSelection) {
        if (!Boolean.valueOf((String)this.modelViewPart.getPersistedState().get(P_LINK_WITH_EDITOR)).booleanValue()) {
            return;
        }
        MPart partToHighlite = null;
        for (MPart part : this.partService.getParts()) {
            if (part.getContext().get("ecpEditorInput") != firstSelection) continue;
            partToHighlite = part;
            break;
        }
        if (partToHighlite == null) {
            return;
        }
        this.partService.showPart(partToHighlite, EPartService.PartState.ACTIVATE);
    }

    @Inject
    public void setActivePart(@Named(value="e4ActivePart") @Optional MPart part) {
        if (this.modelExplorerTree == null) {
            return;
        }
        if (part == null) {
            return;
        }
        if (this.modelViewPart == null || !Boolean.valueOf((String)this.modelViewPart.getPersistedState().get(P_LINK_WITH_EDITOR)).booleanValue()) {
            return;
        }
        Object partInput = part.getContext().get("ecpEditorInput");
        if (partInput == null) {
            return;
        }
        this.modelExplorerTree.setSelection((ISelection)new StructuredSelection(partInput));
    }

    @Focus
    public void setFocus() {
        this.modelExplorerTree.getTree().setFocus();
    }
}

