/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.view.internal.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecp.ide.view.service.IDEViewModelRegistry;
import org.eclipse.emf.ecp.ide.view.service.ViewModelEditorCallback;
import org.eclipse.emf.ecp.internal.ide.util.EcoreHelper;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public class IDEViewModelRegistryImpl
implements IDEViewModelRegistry {
    private static VViewPackage viewPackage = VViewPackage.eINSTANCE;
    private static VViewFactory viewFactory = viewPackage.getViewFactory();
    private final Map<VView, ViewModelEditorCallback> viewModelViewModelEditorMapping = new LinkedHashMap<VView, ViewModelEditorCallback>();
    private final Map<String, Set<VView>> ecoreViewMapping = new LinkedHashMap<String, Set<VView>>();
    private final Map<VView, String> viewModelviewModelFileMapping = new LinkedHashMap<VView, String>();
    private final Map<String, IResourceChangeListener> resourceChangeListeners = new LinkedHashMap<String, IResourceChangeListener>();

    @Override
    public void register(String ecorePath, VView viewModel) {
        if (!this.ecoreViewMapping.containsKey(ecorePath) || this.ecoreViewMapping.get(ecorePath).isEmpty()) {
            if (this.ecoreViewMapping.get(ecorePath) == null) {
                this.ecoreViewMapping.put(ecorePath, new LinkedHashSet());
            }
            if (!this.resourceChangeListeners.containsKey(ecorePath)) {
                this.addECoreChangeListener(ecorePath);
            }
        }
        this.ecoreViewMapping.get(ecorePath).add(viewModel);
    }

    private void addECoreChangeListener(final String ecorePath) {
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    while (delta.getAffectedChildren().length != 0) {
                        delta = delta.getAffectedChildren()[0];
                    }
                    for (VView view : (Set)IDEViewModelRegistryImpl.this.ecoreViewMapping.get(ecorePath)) {
                        ViewModelEditorCallback viewModelEditorCallback;
                        String ecorePath2 = view.getEcorePath();
                        if (ecorePath2 == null) {
                            return;
                        }
                        if (!ecorePath2.contains(delta.getResource().getFullPath().toString()) || (viewModelEditorCallback = (ViewModelEditorCallback)IDEViewModelRegistryImpl.this.viewModelViewModelEditorMapping.get(view)) == null) continue;
                        viewModelEditorCallback.signalEcoreOutOfSync();
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
        this.resourceChangeListeners.put(ecorePath, listener);
    }

    @Override
    public void unregister(String registeredEcorePath, VView viewModel) {
        if (this.ecoreViewMapping.containsKey(registeredEcorePath)) {
            IResourceChangeListener listener;
            this.ecoreViewMapping.get(registeredEcorePath).remove(viewModel);
            if (this.ecoreViewMapping.get(registeredEcorePath).size() == 0 && (listener = this.resourceChangeListeners.get(registeredEcorePath)) != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
                this.resourceChangeListeners.remove(registeredEcorePath);
            }
        }
    }

    @Override
    public void registerViewModelEditor(VView viewModel, ViewModelEditorCallback viewModelEditor) throws IOException {
        this.viewModelViewModelEditorMapping.put(viewModel, viewModelEditor);
        String ecorePath = viewModel.getEcorePath();
        EcoreHelper.registerEcore((String)ecorePath);
    }

    @Override
    public void unregisterViewModelEditor(VView viewModel, ViewModelEditorCallback viewModelEditor) {
        this.viewModelViewModelEditorMapping.remove(viewModel);
        String ecorePath = viewModel.getEcorePath();
        if (ecorePath != null) {
            EcoreHelper.unregisterEcore((String)ecorePath);
        }
    }

    @Override
    public void registerViewModel(VView view, String path) {
        if (!this.viewModelviewModelFileMapping.containsKey(view)) {
            this.viewModelviewModelFileMapping.put(view, path);
        }
    }

    @Override
    public VView createViewModel(IFile modelFile, EClass selectedEClass, IFile selectedEcore) throws IOException {
        EPackage ep;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{adapterFactory, new ReflectiveItemProviderAdapterFactory()});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        Resource resource = domain.createResource(fileURI.toString());
        VView view = (VView)this.createInitialModel();
        if (view == null) {
            return null;
        }
        resource.getContents().add((Object)view);
        Resource r = selectedEClass.eResource();
        EPackage ePackage = (EPackage)r.getContents().get(0);
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        Object ePackageObject = instance.get((Object)ePackage.getNsURI());
        if (EPackage.Descriptor.class.isInstance(ePackageObject)) {
            EPackage.Descriptor descriptor = (EPackage.Descriptor)EPackage.Descriptor.class.cast(ePackageObject);
            ep = descriptor.getEPackage();
        } else {
            ep = EPackage.class.isInstance(ePackageObject) ? (EPackage)ePackageObject : null;
        }
        if (ep == null) {
            EcoreHelper.registerEcore((String)selectedEcore.getFullPath().toString());
            ep = (EPackage)instance.get((Object)ePackage.getNsURI());
        }
        EClass ec = (EClass)ep.getEClassifier(selectedEClass.getName());
        view.setRootEClass(ec);
        view.setEcorePath(selectedEcore.getFullPath().toString());
        HashMap options = new HashMap();
        resource.save(options);
        return view;
    }

    private EObject createInitialModel() {
        VView rootObject = viewFactory.createView();
        return rootObject;
    }
}

