/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util.observer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPObserverBus;
import org.eclipse.emf.ecp.internal.core.util.observer.ECPObserverCall;
import org.eclipse.emf.ecp.internal.core.util.observer.ECPPrioritizedIObserver;

public class ECPObserverBusImpl
implements ECPObserverBus {
    private HashMap<Class<? extends ECPObserver>, List<ECPObserver>> observerMap = new HashMap();

    public static ECPObserverBusImpl getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public <T extends ECPObserver> T notify(Class<T> clazz) {
        return this.notify(clazz, false);
    }

    public <T extends ECPObserver> T notify(Class<T> clazz, boolean prioritized) {
        if (clazz == null) {
            return null;
        }
        return this.createProxy(clazz, false);
    }

    @Override
    public void register(ECPObserver observer) {
        this.register(observer, this.getObserverInterfaces(observer));
    }

    public void register(ECPObserver observer, Class<? extends ECPObserver> ... classes) {
        Class<? extends ECPObserver>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends ECPObserver> iface = classArray[n2];
            if (iface.isInstance(observer)) {
                this.addObserver(observer, iface);
            }
            ++n2;
        }
    }

    @Override
    public void unregister(ECPObserver observer) {
        this.unregister(observer, this.getObserverInterfaces(observer));
    }

    public void unregister(ECPObserver observer, Class<? extends ECPObserver> ... classes) {
        Class<? extends ECPObserver>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends ECPObserver> iface = classArray[n2];
            if (iface.isInstance(observer)) {
                this.removeObserver(observer, iface);
            }
            ++n2;
        }
    }

    private void addObserver(ECPObserver observer, Class<? extends ECPObserver> iface) {
        List<ECPObserver> observers = this.initObserverList(iface);
        observers.add(observer);
    }

    private void removeObserver(ECPObserver observer, Class<? extends ECPObserver> iface) {
        List<ECPObserver> observers = this.initObserverList(iface);
        observers.remove(observer);
    }

    private List<ECPObserver> initObserverList(Class<? extends ECPObserver> iface) {
        List<ECPObserver> list = this.observerMap.get(iface);
        if (list == null) {
            list = new ArrayList<ECPObserver>();
            this.observerMap.put(iface, list);
        }
        return list;
    }

    private List<ECPObserver> getObserverByClass(Class<? extends ECPObserver> clazz) {
        List<ECPObserver> list = this.observerMap.get(clazz);
        if (list == null) {
            list = Collections.emptyList();
        }
        return new ArrayList<ECPObserver>(list);
    }

    private boolean isPrioritizedObserver(Class<?> clazz, Method method) {
        if (!clazz.equals(method.getDeclaringClass())) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            if (ECPPrioritizedIObserver.class.equals(interfaceClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private <T extends ECPObserver> T createProxy(Class<T> clazz, boolean prioritized) {
        ProxyHandler handler = new ProxyHandler(clazz, prioritized);
        return (T)((ECPObserver)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, ECPObserverCall.class}, (InvocationHandler)handler));
    }

    private void sortObservers(List<ECPObserver> observers) {
        Collections.sort(observers, new Comparator<ECPObserver>(){

            @Override
            public int compare(ECPObserver o1, ECPObserver o2) {
                int prio2;
                int prio1 = ((ECPPrioritizedIObserver)o1).getPriority();
                if (prio1 == (prio2 = ((ECPPrioritizedIObserver)o2).getPriority())) {
                    return 0;
                }
                return prio1 > prio2 ? 1 : -1;
            }
        });
    }

    private Class<? extends ECPObserver>[] getObserverInterfaces(ECPObserver observer) {
        HashSet<Class<? extends ECPObserver>> observerInterfacsFound = new HashSet<Class<? extends ECPObserver>>();
        this.getClasses(observer.getClass(), observerInterfacsFound);
        return observerInterfacsFound.toArray(new Class[observerInterfacsFound.size()]);
    }

    private boolean getClasses(Class<?> clazz, HashSet<Class<? extends ECPObserver>> result) {
        for (Class<?> iface : this.getAllInterfaces(clazz, new HashSet())) {
            if (iface.equals(ECPObserver.class) && clazz.isInterface()) {
                result.add(clazz);
                return true;
            }
            if (!this.getClasses(iface, result) || !clazz.isInterface()) continue;
            result.add(clazz);
        }
        return false;
    }

    private Set<Class<?>> getAllInterfaces(Class<?> clazz, Set<Class<?>> interfacesFound) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            interfacesFound.add(iface);
            ++n2;
        }
        if (clazz.getSuperclass() == null) {
            return interfacesFound;
        }
        return this.getAllInterfaces(clazz.getSuperclass(), interfacesFound);
    }

    private final class ProxyHandler
    implements InvocationHandler,
    ECPObserverCall {
        private Class<ECPObserver> clazz;
        private List<ECPObserverCall.Result> lastResults;
        private boolean prioritized;

        public ProxyHandler(Class<ECPObserver> clazz, boolean prioritized) {
            this.clazz = clazz;
            this.prioritized = prioritized;
            this.lastResults = new ArrayList<ECPObserverCall.Result>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ECPObserverCall.class.equals(method.getDeclaringClass())) {
                return this.accessObserverCall(method, args);
            }
            List observers = ECPObserverBusImpl.this.getObserverByClass(this.clazz);
            if (this.prioritized && ECPObserverBusImpl.this.isPrioritizedObserver(this.clazz, method)) {
                ECPObserverBusImpl.this.sortObservers(observers);
            }
            if (observers.size() == 0) {
                this.lastResults = new ArrayList<ECPObserverCall.Result>();
                return ECPObserverCall.Result.getDefaultValue(method);
            }
            this.lastResults = this.notifiyObservers(observers, method, args);
            ArrayList<Object> result = new ArrayList<Object>();
            for (ECPObserverCall.Result resultObject : this.lastResults) {
                Object res = resultObject.getResultOrDefaultValue();
                if (res instanceof Object[]) {
                    Object[] arrayRes = (Object[])res;
                    result.addAll(Arrays.asList(arrayRes));
                    continue;
                }
                if (res instanceof Collection) {
                    result.addAll((Collection)res);
                    continue;
                }
                result.add(res);
            }
            return result;
        }

        private Object accessObserverCall(Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return method.invoke((Object)this, args);
        }

        private List<ECPObserverCall.Result> notifiyObservers(List<ECPObserver> observers, Method method, Object[] args) {
            ArrayList<ECPObserverCall.Result> results = new ArrayList<ECPObserverCall.Result>(observers.size());
            for (ECPObserver observer : observers) {
                try {
                    results.add(new ECPObserverCall.Result(observer, method, method.invoke((Object)observer, args)));
                }
                catch (Throwable e) {
                    results.add(new ECPObserverCall.Result(observer, e, method));
                }
            }
            return results;
        }

        @Override
        public List<ECPObserverCall.Result> getObserverCallResults() {
            return this.lastResults;
        }
    }

    private static class SingletonHolder {
        public static final ECPObserverBusImpl INSTANCE = new ECPObserverBusImpl();

        private SingletonHolder() {
        }
    }
}

