/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ide.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EcoreHelper {
    private static final Map<String, List<String>> registeredEPackages = new HashMap<String, List<String>>();

    private EcoreHelper() {
    }

    public static void registerEcore(String ecorePath) throws IOException {
        if (ecorePath == null) {
            return;
        }
        ResourceSetImpl physicalResourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)ecorePath, (boolean)false);
        Resource r = physicalResourceSet.createResource(uri);
        r.load(null);
        int rsSize = physicalResourceSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
        while (rsSize != physicalResourceSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
            rsSize = physicalResourceSet.getResources().size();
        }
        ResourceSetImpl virtualResourceSet = new ResourceSetImpl();
        for (Resource physicalResource : physicalResourceSet.getResources()) {
            EObject eObject = (EObject)physicalResource.getContents().get(0);
            EPackage ePackage = (EPackage)EPackage.class.cast(eObject);
            if (EcoreHelper.isContainedInPackageRegistry(ePackage.getNsURI())) {
                return;
            }
            physicalResource.getContents().remove((Object)ePackage);
            Resource virtualResource = virtualResourceSet.createResource(URI.createURI((String)ePackage.getNsURI()));
            virtualResource.getContents().add((Object)ePackage);
            EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
            if (registeredEPackages.get(ecorePath) == null) {
                registeredEPackages.put(ecorePath, new ArrayList());
            }
            registeredEPackages.get(ecorePath).add(ePackage.getNsURI());
        }
    }

    private static boolean isContainedInPackageRegistry(String nsURI) {
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        return instance.containsKey((Object)nsURI);
    }

    public static void unregisterEcore(String ecorePath) {
        ArrayList<String> nsURIs = new ArrayList<String>((Collection)registeredEPackages.get(ecorePath));
        EcoreHelper.unregisterEcore(ecorePath, nsURIs);
    }

    private static void unregisterEcore(String ecorePath, List<String> nsURIs) {
        if (nsURIs == null) {
            return;
        }
        for (String nsURI : nsURIs) {
            if (EcoreHelper.getUsageCount(nsURI) != 1) continue;
            EPackage.Registry registry = EPackage.Registry.INSTANCE;
            registry.remove((Object)nsURI);
            registeredEPackages.get(ecorePath).remove(nsURI);
        }
    }

    private static int getUsageCount(String nsURI) {
        int usage = 0;
        for (String ecore : registeredEPackages.keySet()) {
            for (String uri : registeredEPackages.get(ecore)) {
                if (!nsURI.equals(uri)) continue;
                ++usage;
            }
        }
        return usage;
    }
}

